/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.api.blockinformation;

import com.mojang.serialization.DataResult;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import mod.chiselsandbits.api.block.state.id.IBlockStateIdManager;
import mod.chiselsandbits.api.util.BlockStateSerializationUtils;
import mod.chiselsandbits.api.util.ComparatorUtils;
import mod.chiselsandbits.api.util.INBTSerializable;
import mod.chiselsandbits.api.util.IPacketBufferSerializable;
import mod.chiselsandbits.api.util.ISnapshotable;
import mod.chiselsandbits.api.variant.state.IStateVariant;
import mod.chiselsandbits.api.variant.state.IStateVariantManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public final class BlockInformation
implements INBTSerializable<CompoundTag>,
IPacketBufferSerializable,
ISnapshotable<BlockInformation>,
Comparable<BlockInformation> {
    public static final BlockInformation AIR = new BlockInformation(Blocks.f_50016_.m_49966_());
    private static final Comparator<BlockState> STATE_COMPARATOR = Comparator.comparing(IBlockStateIdManager.getInstance()::getIdFrom);
    private static final Comparator<IStateVariant> VARIANT_COMPARATOR = Comparator.comparing(variant -> variant.getClass().getName()).thenComparing(Comparator.naturalOrder());
    private static final Comparator<Optional<IStateVariant>> OPTIONAL_VARIANT_COMPARATOR = ComparatorUtils.createOptionalComparator(VARIANT_COMPARATOR);
    private static final Comparator<BlockInformation> COMPARATOR = Comparator.comparing(BlockInformation::getBlockState, STATE_COMPARATOR).thenComparing(BlockInformation::getVariant, OPTIONAL_VARIANT_COMPARATOR);
    private BlockState blockState;
    private Optional<IStateVariant> variant;

    public BlockInformation(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    public BlockInformation(FriendlyByteBuf packetBuffer) {
        this.deserializeFrom(packetBuffer);
    }

    public BlockInformation(BlockState blockState, Optional<IStateVariant> variant) {
        this.blockState = blockState;
        this.variant = variant;
    }

    public BlockInformation(BlockState blockState) {
        this.blockState = blockState;
        this.variant = Optional.empty();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("state", BlockStateSerializationUtils.serialize(this.getBlockState()));
        this.getVariant().ifPresent(info -> tag.m_128365_("variant", (Tag)IStateVariantManager.getInstance().serializeNBT((IStateVariant)info)));
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        DataResult<BlockState> dataResult = BlockStateSerializationUtils.deserialize(nbt.m_128461_("state"));
        this.blockState = dataResult.result().orElseGet(() -> ((Block)Blocks.f_50016_).m_49966_());
        this.variant = Optional.empty();
        if (nbt.m_128441_("variant")) {
            this.variant = Optional.of(IStateVariantManager.getInstance().deserializeNBT(nbt.m_128469_("variant")));
        }
    }

    @Override
    public void serializeInto(@NotNull FriendlyByteBuf packetBuffer) {
        BlockStateSerializationUtils.serialize(packetBuffer, this.getBlockState());
        packetBuffer.writeBoolean(this.getVariant().isPresent());
        this.getVariant().ifPresent(info -> IStateVariantManager.getInstance().serializeInto(packetBuffer, (IStateVariant)info));
    }

    @Override
    public void deserializeFrom(@NotNull FriendlyByteBuf packetBuffer) {
        this.blockState = BlockStateSerializationUtils.deserialize(packetBuffer);
        this.variant = Optional.empty();
        if (packetBuffer.readBoolean()) {
            this.variant = Optional.of(IStateVariantManager.getInstance().deserializeFrom(packetBuffer));
        }
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public Optional<IStateVariant> getVariant() {
        return this.variant;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BlockInformation that = (BlockInformation)obj;
        return Objects.equals(this.blockState, that.blockState) && Objects.equals(this.variant, that.variant);
    }

    public int hashCode() {
        return Objects.hash(this.blockState, this.variant);
    }

    public String toString() {
        return "BlockInformation[blockState=" + this.blockState + ", variant=" + this.variant + "]";
    }

    public boolean isAir() {
        return this.getBlockState().m_60795_();
    }

    @Override
    public BlockInformation createSnapshot() {
        if (this.getVariant().isPresent()) {
            return new BlockInformation(this.blockState, Optional.ofNullable((IStateVariant)this.getVariant().get().createSnapshot()));
        }
        return new BlockInformation(this.blockState);
    }

    @Override
    public int compareTo(@NotNull BlockInformation o) {
        return COMPARATOR.compare(this, o);
    }
}

