/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.commands;

import com.google.gson.Gson;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.commands.LootCommand;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraftforge.fml.loading.FMLPaths;

public class SerializeLootTableCommand {
    public static final Gson GSON = Deserializers.m_78800_().setPrettyPrinting().create();
    public static final DynamicCommandExceptionType NOT_FOUND = new DynamicCommandExceptionType(arg -> new TranslatableComponent("placebo.cmd.not_found", new Object[]{arg}));

    public static void register(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"serialize_loot_table").then(Commands.m_82129_((String)"loot_table", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(LootCommand.f_137877_).executes(ctx -> {
            ResourceLocation id = ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"loot_table");
            LootTable table = ((CommandSourceStack)ctx.getSource()).m_81377_().m_129898_().m_79217_(id);
            if (table == LootTable.f_79105_) {
                throw NOT_FOUND.create((Object)id);
            }
            String path = "placebo_serialized/" + id.m_135827_() + "/loot_tables/" + id.m_135815_() + ".json";
            File file = new File(FMLPaths.GAMEDIR.get().toFile(), path);
            file.getParentFile().mkdirs();
            if (SerializeLootTableCommand.attemptSerialize(table, file)) {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("placebo.cmd.serialize_success", new Object[]{id, path}), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)new TranslatableComponent("placebo.cmd.serialize_failure"));
            }
            return 0;
        })));
    }

    public static boolean attemptSerialize(LootTable table, File file) {
        String json = GSON.toJson((Object)table);
        try (FileWriter w = new FileWriter(file);){
            w.write(json);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

