/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.placebo.json.NBTAdapter;

public class ItemAdapter
implements JsonDeserializer<ItemStack>,
JsonSerializer<ItemStack> {
    public static final ItemAdapter INSTANCE = new ItemAdapter();
    public static final Gson ITEM_READER = new GsonBuilder().registerTypeAdapter(ItemStack.class, (Object)INSTANCE).registerTypeAdapter(CompoundTag.class, (Object)NBTAdapter.INSTANCE).create();

    public ItemStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext ctx) throws JsonParseException {
        boolean optional;
        JsonObject obj = json.getAsJsonObject();
        ResourceLocation id = new ResourceLocation(obj.get("item").getAsString());
        Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
        boolean bl = optional = obj.has("optional") ? obj.get("optional").getAsBoolean() : false;
        if (!optional && item == Items.f_41852_ && !id.equals((Object)Items.f_41852_.getRegistryName())) {
            throw new JsonParseException("Failed to read non-optional item " + id);
        }
        int count = obj.has("count") ? obj.get("count").getAsInt() : 1;
        CompoundTag tag = obj.has("nbt") ? (CompoundTag)ctx.deserialize(obj.get("nbt"), CompoundTag.class) : null;
        CompoundTag capTag = obj.has("cap_nbt") ? (CompoundTag)ctx.deserialize(obj.get("cap_nbt"), CompoundTag.class) : null;
        ItemStack stack = new ItemStack((ItemLike)item, count, capTag);
        stack.m_41751_(tag);
        return stack;
    }

    public JsonElement serialize(ItemStack stack, Type typeOfSrc, JsonSerializationContext ctx) {
        CompoundTag written = stack.m_41739_(new CompoundTag());
        JsonObject obj = new JsonObject();
        obj.add("item", ctx.serialize((Object)stack.m_41720_().getRegistryName().toString()));
        obj.add("count", ctx.serialize((Object)stack.m_41613_()));
        if (stack.m_41782_()) {
            obj.add("nbt", ctx.serialize((Object)stack.m_41783_()));
        }
        if (written.m_128441_("ForgeCaps")) {
            obj.add("cap_nbt", ctx.serialize((Object)written.m_128469_("ForgeCaps")));
        }
        return obj;
    }
}

