/*
 * Decompiled with CFR 0.152.
 */
package mca.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import mca.client.model.ModelTransformSet;
import mca.entity.GrimReaperEntity;
import mca.entity.ReaperAttackState;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class GrimReaperEntityModel<T extends GrimReaperEntity>
extends HumanoidModel<T> {
    private static final Map<ReaperAttackState, ModelTransformSet> POSES = ImmutableMap.of((Object)((Object)ReaperAttackState.PRE), (Object)new ModelTransformSet.Builder().rotate("head", -15.6f, 40.4f, 0.0f).rotate("body", 0.0f, -13.0f, 0.0f).rotate("left_arm", -130.0f, -112.0f, 7.8f).rotate("right_arm", -36.5f, 122.6f, 0.0f).rotate("left_leg", 18.0f, -13.0f, 0.0f).rotate("right_leg", 13.0f, -13.0f, 0.0f).rotate("scythe_handle", 0.0f, 0.0f, 90.0f).build(), (Object)((Object)ReaperAttackState.POST), (Object)new ModelTransformSet.Builder().rotate("head", 44.3f, 41.7f, 0.0f).rotate("body", 34.0f, 34.0f, 0.0f).rotate("left_arm", -44.0f, 62.0f, 7.8f).with("right_arm", -5.0f, 1.7f, 3.3f, -36.5f, 122.6f, 0.0f).with("left_leg", 5.4f, 9.8f, 4.6f, 28.7f, 39.0f, -2.6f).with("right_leg", 2.0f, 10.0f, 6.6f, 31.3f, 34.0f, -5.2f).with("scythe_handle", -10.0f, 10.0f, 0.0f, 0.0f, -10.0f, 90.0f).build(), (Object)((Object)ReaperAttackState.BLOCK), (Object)new ModelTransformSet.Builder().rotate("head", 7.8f, 0.0f, 0.0f).with("body", 0.0f, 0.0f, 1.0f, -5.2f, 5.2f, 0.0f).rotate("left_arm", -86.0f, 23.5f, 7.8f).rotate("right_arm", -70.0f, 0.0f, 107.0f).rotate("left_leg", -7.8f, 2.6f, 0.0f).rotate("right_leg", -7.8f, 5.2f, 0.0f).rotate("scythe_handle", 120.0f, 88.0f, 0.0f).build(), (Object)((Object)ReaperAttackState.REST), (Object)new ModelTransformSet.Builder().rotate("head", 62.6f, 0.0f, 1.8f).rotate("body", 0.0f, 5.2f, 0.0f).rotate("left_arm", 0.0f, 0.0f, -20.0f, ModelTransformSet.Op.ADD).rotate("right_arm", 0.0f, 0.0f, 20.0f, ModelTransformSet.Op.ADD).rotate("left_leg", 2.6f, 2.6f, 0.0f).rotate("right_leg", 2.6f, 5.2f, 0.0f).with("scythe_handle", 0.0f, 10.0f, 0.0f, 90.0f, -20.0f, 90.0f, ModelTransformSet.Op.KEEP, ModelTransformSet.Op.KEEP).build());
    private final ModelPart scythe;
    public ReaperAttackState reaperState = ReaperAttackState.IDLE;
    private final PartPose scytheTransform;

    public GrimReaperEntityModel(ModelPart tree) {
        super(tree);
        this.scythe = tree.m_171324_("left_arm").m_171324_("scythe_handle");
        this.scytheTransform = this.scythe.m_171308_();
    }

    public static MeshDefinition getModelData(CubeDeformation dilation) {
        MeshDefinition modelData = HumanoidModel.m_170681_((CubeDeformation)dilation, (float)0.0f);
        PartDefinition data = modelData.m_171576_();
        data.m_171597_("left_arm").m_171599_("scythe_handle", CubeListBuilder.m_171558_().m_171514_(36, 32).m_171488_(0.0f, -26.0f, 0.0f, 1.0f, 31.0f, 1.0f, dilation).m_171514_(0, 32).m_171488_(0.5f, -26.0f, 0.5f, 16.0f, 16.0f, 0.0f, dilation), ModelTransformSet.Builder.createTransform(0.0f, 10.0f, 0.0f, 90.0f, -20.0f, 90.0f));
        return modelData;
    }

    public void setAngles(T entity, float f, float g, float h, float i, float j) {
        super.m_6973_(entity, f, g, h, i, j);
        this.f_102810_.m_104227_(0.0f, 0.0f, 0.0f);
        this.f_102810_.m_171327_(0.0f, 0.0f, 0.0f);
        this.f_102814_.m_104227_(1.9f, 12.0f, 0.0f);
        this.f_102814_.m_171327_(0.0f, 0.0f, 0.0f);
        this.f_102813_.m_104227_(-1.9f, 12.0f, 0.0f);
        this.f_102813_.m_171327_(0.0f, 0.0f, 0.0f);
        this.scythe.m_171322_(this.scytheTransform);
        this.reaperState = ((GrimReaperEntity)entity).getAttackState();
        ModelTransformSet set = POSES.get((Object)this.reaperState);
        if (set != null) {
            set.get("head").applyTo(this.f_102808_);
            set.get("body").applyTo(this.f_102810_);
            set.get("left_arm").applyTo(this.f_102812_);
            set.get("right_arm").applyTo(this.f_102811_);
            set.get("left_leg").applyTo(this.f_102814_);
            set.get("right_leg").applyTo(this.f_102813_);
            set.get("scythe_handle").applyTo(this.scythe);
        }
        this.f_102809_.m_104315_(this.f_102808_);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.f_102808_, (Object)this.f_102809_);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.f_102810_, (Object)this.f_102811_, (Object)this.f_102812_, (Object)this.f_102813_, (Object)this.f_102814_);
    }
}

