/*
 * Decompiled with CFR 0.152.
 */
package mca.client.model;

import com.google.common.collect.ImmutableList;
import mca.client.model.VillagerEntityBaseModelMCA;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Mob;

public class VillagerEntityModelMCA<T extends Mob>
extends VillagerEntityBaseModelMCA<T> {
    protected static final String BREASTPLATE = "breastplate";
    public final ModelPart breastsWear;
    public final ModelPart leftArmwear;
    public final ModelPart rightArmwear;
    public final ModelPart leftLegwear;
    public final ModelPart rightLegwear;
    public final ModelPart bodyWear;
    private boolean wearsHidden;

    public VillagerEntityModelMCA(ModelPart tree) {
        super(tree);
        this.bodyWear = tree.m_171324_("jacket");
        this.leftArmwear = tree.m_171324_("left_sleeve");
        this.rightArmwear = tree.m_171324_("right_sleeve");
        this.leftLegwear = tree.m_171324_("left_pants");
        this.rightLegwear = tree.m_171324_("right_pants");
        this.breastsWear = tree.m_171324_(BREASTPLATE);
    }

    public static MeshDefinition hairData(CubeDeformation dilation) {
        MeshDefinition modelData = VillagerEntityModelMCA.bodyData(dilation);
        PartDefinition root = modelData.m_171576_();
        root.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, dilation.m_171469_(0.3f)), PartPose.f_171404_);
        return modelData;
    }

    public static MeshDefinition bodyData(CubeDeformation dilation) {
        MeshDefinition modelData = PlayerModel.m_170825_((CubeDeformation)dilation, (boolean)false);
        PartDefinition root = modelData.m_171576_();
        root.m_171599_("breasts", VillagerEntityModelMCA.newBreasts(dilation, 0), PartPose.f_171404_);
        root.m_171599_(BREASTPLATE, VillagerEntityModelMCA.newBreasts(dilation.m_171469_(0.1f), 16), PartPose.f_171404_);
        return modelData;
    }

    @Override
    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.f_102810_, (Object)this.f_102811_, (Object)this.f_102812_, (Object)this.f_102813_, (Object)this.f_102814_, (Object)this.bodyWear, (Object)this.leftLegwear, (Object)this.rightLegwear, (Object)this.leftArmwear, (Object)this.rightArmwear);
    }

    @Override
    protected Iterable<ModelPart> breastsParts() {
        return ImmutableList.of((Object)this.breasts, (Object)this.breastsWear);
    }

    @Override
    public void setAngles(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        super.setAngles(entity, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
        this.leftLegwear.m_104315_(this.f_102814_);
        this.rightLegwear.m_104315_(this.f_102813_);
        this.leftArmwear.m_104315_(this.f_102812_);
        this.rightArmwear.m_104315_(this.f_102811_);
        this.bodyWear.m_104315_(this.f_102810_);
        this.breastsWear.m_104315_(this.f_102810_);
    }

    public void m_8009_(boolean visible) {
        super.m_8009_(visible);
        this.leftArmwear.f_104207_ = !this.wearsHidden && visible;
        this.rightArmwear.f_104207_ = !this.wearsHidden && visible;
        this.leftLegwear.f_104207_ = !this.wearsHidden && visible;
        this.rightLegwear.f_104207_ = !this.wearsHidden && visible;
        this.bodyWear.f_104207_ = !this.wearsHidden && visible;
    }

    public VillagerEntityModelMCA<T> hideWears() {
        this.wearsHidden = true;
        this.breastsWear.f_104207_ = false;
        this.leftArmwear.f_104207_ = false;
        this.rightArmwear.f_104207_ = false;
        this.leftLegwear.f_104207_ = false;
        this.rightLegwear.f_104207_ = false;
        this.bodyWear.f_104207_ = false;
        return this;
    }

    @Override
    public void m_102872_(HumanoidModel<T> target) {
        super.m_102872_(target);
        if (target instanceof VillagerEntityModelMCA) {
            this.copyAttributes((VillagerEntityModelMCA)target);
        }
    }

    private void copyAttributes(VillagerEntityModelMCA<T> target) {
        target.leftLegwear.m_104315_(this.leftLegwear);
        target.rightLegwear.m_104315_(this.rightLegwear);
        target.leftArmwear.m_104315_(this.leftArmwear);
        target.rightArmwear.m_104315_(this.rightArmwear);
        target.bodyWear.m_104315_(this.bodyWear);
        target.breastsWear.m_104315_(this.breastsWear);
    }
}

