/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.ai;

import java.util.Optional;
import java.util.Random;
import mca.Config;
import mca.advancement.criterion.CriterionMCA;
import mca.entity.VillagerEntityMCA;
import mca.entity.ai.relationship.AgeState;
import mca.entity.ai.relationship.Gender;
import mca.server.world.data.BabyTracker;
import mca.util.WorldUtils;
import mca.util.network.datasync.CDataManager;
import mca.util.network.datasync.CDataParameter;
import mca.util.network.datasync.CParameter;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class Pregnancy {
    private static final CDataParameter<Boolean> HAS_BABY = CParameter.create("hasBaby", false);
    private static final CDataParameter<Boolean> IS_BABY_MALE = CParameter.create("isBabyMale", false);
    private static final CDataParameter<Integer> BABY_AGE = CParameter.create("babyAge", 0);
    private final VillagerEntityMCA mother;

    public static <E extends Entity> CDataManager.Builder<E> createTrackedData(CDataManager.Builder<E> builder) {
        return builder.addAll(HAS_BABY, IS_BABY_MALE, BABY_AGE);
    }

    Pregnancy(VillagerEntityMCA entity) {
        this.mother = entity;
    }

    public boolean isPregnant() {
        return (Boolean)this.mother.getTrackedValue(HAS_BABY);
    }

    public void setPregnant(boolean pregnant) {
        this.mother.setTrackedValue(HAS_BABY, pregnant);
    }

    public int getBabyAge() {
        return (Integer)this.mother.getTrackedValue(BABY_AGE);
    }

    public void setBabyAge(int age) {
        this.mother.setTrackedValue(BABY_AGE, age);
    }

    public Gender getGender() {
        return (Boolean)this.mother.getTrackedValue(IS_BABY_MALE) != false ? Gender.MALE : Gender.FEMALE;
    }

    public void tick() {
        if (!this.isPregnant()) {
            return;
        }
        this.setBabyAge(this.getBabyAge() + 1);
        if (this.getBabyAge() < Config.getInstance().babyGrowUpTime * 60) {
            return;
        }
        this.setBabyAge(0);
        this.getFather().ifPresent(father -> {
            this.setPregnant(false);
            VillagerEntityMCA child = this.createChild(this.getGender(), (VillagerEntityMCA)father);
            child.m_6034_(this.mother.m_20185_(), this.mother.m_20186_(), this.mother.m_20189_());
            WorldUtils.spawnEntity(this.mother.f_19853_, (Entity)child, MobSpawnType.BREEDING);
        });
    }

    public boolean tryStartGestation() {
        if (this.isPregnant()) {
            return false;
        }
        return this.getFather().map(father -> {
            if (this.mother.getGenetics().getGender() == Gender.MALE && father.getGenetics().getGender() != Gender.MALE) {
                return father.getRelationships().getPregnancy().tryStartGestation();
            }
            this.setPregnant(true);
            this.mother.setTrackedValue(IS_BABY_MALE, this.mother.f_19853_.f_46441_.nextBoolean());
            return true;
        }).orElse(false);
    }

    public VillagerEntityMCA createChild(Gender gender, VillagerEntityMCA partner) {
        VillagerEntityMCA child = (VillagerEntityMCA)gender.getVillagerType().m_20615_(this.mother.f_19853_);
        child.getGenetics().combine(partner.getGenetics(), this.mother.getGenetics());
        child.getTraits().inherit(partner.getTraits());
        child.getTraits().inherit(this.mother.getTraits());
        child.m_6863_(true);
        child.setAgeState(AgeState.TODDLER);
        child.getRelationships().getFamilyEntry().assignParents(this.mother.getRelationships(), partner.getRelationships());
        child.getRelationships().getFamily(2, 0).filter(e -> e instanceof ServerPlayer).map(ServerPlayer.class::cast).forEach(CriterionMCA.FAMILY::trigger);
        return child;
    }

    public VillagerEntityMCA createChild(Gender gender) {
        return this.createChild(gender, this.mother);
    }

    private Optional<VillagerEntityMCA> getFather() {
        return this.mother.getRelationships().getSpouse().filter(father -> father instanceof VillagerEntityMCA).map(VillagerEntityMCA.class::cast);
    }

    public void procreate(Entity spouse) {
        int count;
        Random random = this.mother.m_21187_();
        boolean areTwins = random.nextInt(100) < Config.getInstance().chanceToHaveTwins;
        int n = count = areTwins ? 2 : 1;
        if (spouse instanceof ServerPlayer) {
            CriterionMCA.BABY_CRITERION.trigger((ServerPlayer)spouse, count);
        }
        long seed = random.nextLong();
        for (int i = 0; i < count; ++i) {
            BabyTracker.get((ServerLevel)this.mother.f_19853_).getPairing(this.mother.m_142081_(), spouse.m_142081_()).addChild(state -> {
                Player player;
                ItemStack stack = state.setGender(Gender.getRandom()).setOwner((Entity)this.mother).setSeed(seed).createItem();
                if (!(spouse instanceof Player) || !(player = (Player)spouse).m_36356_(stack)) {
                    this.mother.m_141944_().m_19173_(stack);
                }
            });
        }
    }
}

