/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.ai.relationship;

public enum MarriageState {
    SINGLE("notMarried"),
    ENGAGED("engaged"),
    MARRIED_TO_VILLAGER("married"),
    MARRIED_TO_PLAYER("marriedToPlayer"),
    WIDOW("widow");

    private static final MarriageState[] VALUES;
    private final String icon;

    private MarriageState(String icon) {
        this.icon = icon;
    }

    public boolean isMarried() {
        return this == MARRIED_TO_PLAYER || this == MARRIED_TO_VILLAGER;
    }

    public MarriageState base() {
        return this == MARRIED_TO_PLAYER ? MARRIED_TO_VILLAGER : this;
    }

    public String getIcon() {
        return this.icon;
    }

    public static MarriageState byId(int id) {
        if (id < 0 || id >= VALUES.length) {
            return SINGLE;
        }
        return VALUES[id];
    }

    static {
        VALUES = MarriageState.values();
    }
}

