/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.interaction;

import java.util.Comparator;
import java.util.Optional;
import mca.advancement.criterion.CriterionMCA;
import mca.entity.VillagerEntityMCA;
import mca.entity.ai.Chore;
import mca.entity.ai.Memories;
import mca.entity.ai.MoveState;
import mca.entity.ai.ProfessionsMCA;
import mca.entity.ai.relationship.MarriageState;
import mca.entity.ai.relationship.family.FamilyTree;
import mca.entity.ai.relationship.family.FamilyTreeNode;
import mca.entity.interaction.EntityCommandHandler;
import mca.item.ItemsMCA;
import mca.server.world.data.BabyTracker;
import mca.server.world.data.PlayerSaveData;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class VillagerCommandHandler
extends EntityCommandHandler<VillagerEntityMCA> {
    public VillagerCommandHandler(VillagerEntityMCA entity) {
        super(entity);
    }

    @Override
    public boolean handle(ServerPlayer player, String command) {
        Memories memory = ((VillagerEntityMCA)this.entity).getVillagerBrain().getMemoriesForPlayer((Player)player);
        if (MoveState.byCommand(command).filter(state -> {
            ((VillagerEntityMCA)this.entity).getVillagerBrain().setMoveState((MoveState)((Object)state), (Player)player);
            return true;
        }).isPresent()) {
            return true;
        }
        if (Chore.byCommand(command).filter(chore -> {
            ((VillagerEntityMCA)this.entity).getVillagerBrain().assignJob((Chore)((Object)chore), (Player)player);
            CriterionMCA.GENERIC_EVENT_CRITERION.trigger(player, "chores");
            return true;
        }).isPresent()) {
            return true;
        }
        switch (command) {
            case "pick_up": {
                if (player.m_20197_().size() >= 3) {
                    ((Entity)player.m_20197_().get(0)).m_8127_();
                }
                if (((VillagerEntityMCA)this.entity).m_20159_()) {
                    ((VillagerEntityMCA)this.entity).m_8127_();
                } else {
                    ((VillagerEntityMCA)this.entity).m_7998_((Entity)player, true);
                }
                player.f_8906_.m_141995_((Packet)new ClientboundSetPassengersPacket((Entity)player));
                return false;
            }
            case "ridehorse": {
                if (((VillagerEntityMCA)this.entity).m_20159_()) {
                    ((VillagerEntityMCA)this.entity).m_8127_();
                } else {
                    ((VillagerEntityMCA)this.entity).f_19853_.m_6249_((Entity)player, player.m_142469_().m_82400_(10.0), e -> e instanceof Saddleable && ((Saddleable)e).m_6254_()).stream().filter(horse -> !horse.m_20160_()).min(Comparator.comparingDouble(a -> a.m_20280_(this.entity))).ifPresentOrElse(horse -> {
                        ((VillagerEntityMCA)this.entity).m_7998_((Entity)horse, false);
                        ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "interaction.ridehorse.success", new Object[0]);
                    }, () -> ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "interaction.ridehorse.fail.notnearby", new Object[0]));
                }
                return true;
            }
            case "sethome": {
                ((VillagerEntityMCA)this.entity).getResidency().setHome((Player)player);
                return true;
            }
            case "gohome": {
                ((VillagerEntityMCA)this.entity).getResidency().goHome((Player)player);
                this.stopInteracting();
                return false;
            }
            case "setworkplace": {
                ((VillagerEntityMCA)this.entity).getResidency().setWorkplace((Player)player);
                return true;
            }
            case "sethangout": {
                ((VillagerEntityMCA)this.entity).getResidency().setHangout((Player)player);
                return true;
            }
            case "trade": {
                this.prepareOffersFor((Player)player);
                return false;
            }
            case "inventory": {
                player.m_5893_((MenuProvider)this.entity);
                return false;
            }
            case "gift": {
                ((VillagerEntityMCA)this.entity).getRelationships().giveGift(player, memory);
                return true;
            }
            case "adopt": {
                ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "interaction.adopt.success", new Object[0]);
                FamilyTreeNode parentNode = FamilyTree.get(player.m_183503_()).getOrCreate((Entity)player);
                ((VillagerEntityMCA)this.entity).getRelationships().getFamilyEntry().assignParent(parentNode);
                Optional<FamilyTreeNode> parentSpouse = FamilyTree.get(player.m_183503_()).getOrEmpty(parentNode.spouse());
                parentSpouse.ifPresent(p -> ((VillagerEntityMCA)this.entity).getRelationships().getFamilyEntry().assignParent((FamilyTreeNode)p));
                break;
            }
            case "procreate": {
                BabyTracker tracker = BabyTracker.get((ServerLevel)((VillagerEntityMCA)this.entity).f_19853_);
                if (tracker.hasActiveBaby(player.m_142081_(), ((VillagerEntityMCA)this.entity).m_142081_())) {
                    BabyTracker.Pairing pairing = tracker.getPairing(player.m_142081_(), ((VillagerEntityMCA)this.entity).m_142081_());
                    if (((BabyTracker.Placement)((Object)pairing.locateBaby((Player)player).getRight())).wasFound()) {
                        ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "interaction.procreate.fail.hasbaby", new Object[0]);
                    } else {
                        ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "interaction.procreate.fail.lostbaby", new Object[0]);
                        pairing.reconstructBaby(player);
                    }
                } else if (memory.getHearts() < 100) {
                    ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "interaction.procreate.fail.lowhearts", new Object[0]);
                } else {
                    ((VillagerEntityMCA)this.entity).getRelationships().startProcreating();
                }
                return true;
            }
            case "divorcePapers": {
                player.m_150109_().m_36054_(new ItemStack((ItemLike)ItemsMCA.DIVORCE_PAPERS.get()));
                return true;
            }
            case "divorceConfirm": {
                ItemStack papers = ((Item)ItemsMCA.DIVORCE_PAPERS.get()).m_7968_();
                Memories memories = ((VillagerEntityMCA)this.entity).getVillagerBrain().getMemoriesForPlayer((Player)player);
                if (player.m_150109_().m_36063_(papers)) {
                    ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "divorcePaper", new Object[0]);
                    player.m_150109_().m_36057_(papers);
                    memories.modHearts(-20);
                } else {
                    ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "divorce", new Object[0]);
                    memories.modHearts(-200);
                }
                ((VillagerEntityMCA)this.entity).getVillagerBrain().modifyMoodValue(-5);
                ((VillagerEntityMCA)this.entity).getRelationships().endMarriage(MarriageState.SINGLE);
                PlayerSaveData playerData = PlayerSaveData.get(player.m_183503_(), player.m_142081_());
                playerData.endMarriage(MarriageState.SINGLE);
                return true;
            }
            case "execute": {
                ((VillagerEntityMCA)this.entity).setProfession((VillagerProfession)ProfessionsMCA.OUTLAW.get());
                return true;
            }
            case "pardon": {
                ((VillagerEntityMCA)this.entity).setProfession(VillagerProfession.f_35585_);
                return true;
            }
            case "infected": {
                ((VillagerEntityMCA)this.entity).setInfected(!((VillagerEntityMCA)this.entity).isInfected());
                return true;
            }
            case "stopworking": {
                ((VillagerEntityMCA)this.entity).getVillagerBrain().abandonJob();
                return true;
            }
            case "armor": {
                ((VillagerEntityMCA)this.entity).getVillagerBrain().setArmorWear(!((VillagerEntityMCA)this.entity).getVillagerBrain().getArmorWear());
                if (((VillagerEntityMCA)this.entity).getVillagerBrain().getArmorWear()) {
                    ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "armor.enabled", new Object[0]);
                } else {
                    ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "armor.disabled", new Object[0]);
                }
                return true;
            }
            case "profession.none": {
                ((VillagerEntityMCA)this.entity).setProfession(VillagerProfession.f_35585_);
                ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "profession.set.none", new Object[0]);
                return true;
            }
            case "profession.guard": {
                ((VillagerEntityMCA)this.entity).setProfession((VillagerProfession)ProfessionsMCA.GUARD.get());
                ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "profession.set.guard", new Object[0]);
                return true;
            }
            case "profession.archer": {
                ((VillagerEntityMCA)this.entity).setProfession((VillagerProfession)ProfessionsMCA.ARCHER.get());
                ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "profession.set.archer", new Object[0]);
                return true;
            }
        }
        return super.handle(player, command);
    }

    public void prepareOffersFor(Player player) {
        MobEffectInstance effectInstance;
        int i = ((VillagerEntityMCA)this.entity).m_35532_(player);
        if (i != 0) {
            for (MerchantOffer tradeOffer : ((VillagerEntityMCA)this.entity).m_6616_()) {
                tradeOffer.m_45353_(-Mth.m_14143_((float)((float)i * tradeOffer.m_45378_())));
            }
        }
        if (player.m_21023_(MobEffects.f_19595_) && (effectInstance = player.m_21124_(MobEffects.f_19595_)) != null) {
            int k = effectInstance.m_19564_();
            for (MerchantOffer merchantOffer : ((VillagerEntityMCA)this.entity).m_6616_()) {
                double d0 = 0.3 + 0.0625 * (double)k;
                int j = (int)Math.floor(d0 * (double)merchantOffer.m_45352_().m_41613_());
                merchantOffer.m_45353_(-Math.max(j, 1));
            }
        }
        ((VillagerEntityMCA)this.entity).m_7189_(player);
        ((VillagerEntityMCA)this.entity).m_45301_(player, ((VillagerEntityMCA)this.entity).m_5446_(), ((VillagerEntityMCA)this.entity).m_7141_().m_35576_());
    }
}

