/*
 * Decompiled with CFR 0.152.
 */
package mca.item;

import java.util.List;
import java.util.Random;
import mca.SoundsMCA;
import mca.TagsMCA;
import mca.advancement.criterion.CriterionMCA;
import mca.block.TombstoneBlock;
import mca.entity.EntitiesMCA;
import mca.util.localization.FlowingText;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ScytheItem
extends SwordItem {
    public ScytheItem(Item.Properties settings) {
        super((Tier)Tiers.GOLD, 10, -2.4f, settings);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        tooltip.addAll(FlowingText.wrap((Component)new TranslatableComponent(this.m_5671_(stack) + ".tooltip").m_130940_(ChatFormatting.GRAY), 160));
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        boolean active = stack.m_41784_().m_128471_("active");
        Random r = entity.f_19853_.f_46441_;
        if (active != selected) {
            stack.m_41784_().m_128379_("active", selected);
            float baseVolume = selected ? 0.75f : 0.25f;
            entity.f_19853_.m_5594_(null, entity.m_142538_(), (SoundEvent)SoundsMCA.reaper_scythe_out.get(), entity.m_5720_(), baseVolume + r.nextFloat() / 2.0f, 0.65f + r.nextFloat() / 10.0f);
        }
        if (selected && living.f_20913_ == -1) {
            entity.f_19853_.m_5594_(null, entity.m_142538_(), (SoundEvent)SoundsMCA.reaper_scythe_swing.get(), entity.m_5720_(), 0.25f, 1.0f);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        user.m_6672_(hand);
        return super.m_7203_(world, user, hand);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (ScytheItem.hasSoul(context.m_43722_())) {
            InteractionResult result = ScytheItem.use(context, false);
            if (result == InteractionResult.SUCCESS) {
                ScytheItem.setSoul(context.m_43722_(), false);
            }
            if (result != InteractionResult.PASS) {
                return result;
            }
        }
        return super.m_6225_(context);
    }

    public boolean m_5812_(ItemStack stack) {
        return super.m_5812_(stack) || ScytheItem.hasSoul(stack);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (target.f_19853_.f_46441_.nextInt(50) > 40) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 1000, 1));
        }
        SoundEvent sound = (SoundEvent)SoundsMCA.reaper_scythe_out.get();
        if (!ScytheItem.hasSoul(stack) && target.m_21224_() && (target.m_6095_() == EntitiesMCA.MALE_VILLAGER.get() || target.m_6095_() == EntitiesMCA.FEMALE_VILLAGER.get())) {
            ScytheItem.setSoul(stack, true);
            sound = SoundEvents.f_11700_;
            if (attacker instanceof ServerPlayer) {
                CriterionMCA.GENERIC_EVENT_CRITERION.trigger((ServerPlayer)attacker, "scytheKill");
            }
        }
        Random r = attacker.f_19853_.f_46441_;
        attacker.f_19853_.m_5594_(null, attacker.m_142538_(), sound, attacker.m_5720_(), 0.75f + r.nextFloat() / 2.0f, 0.75f + r.nextFloat() / 2.0f);
        return super.m_7579_(stack, target, attacker);
    }

    public boolean m_6832_(ItemStack stack, ItemStack ingredient) {
        return stack.m_41720_() == ingredient.m_41720_();
    }

    public static void setSoul(ItemStack stack, boolean soul) {
        stack.m_41784_().m_128379_("hasSoul", soul);
    }

    public static boolean hasSoul(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128471_("hasSoul");
    }

    public static InteractionResult use(UseOnContext context, boolean cure) {
        BlockPos pos;
        Level world = context.m_43725_();
        BlockState state = world.m_8055_(pos = context.m_8083_());
        if (state.m_204336_(TagsMCA.Blocks.TOMBSTONES)) {
            return TombstoneBlock.Data.of(world.m_7702_(pos)).filter(TombstoneBlock.Data::hasEntity).map(data -> {
                if (!context.m_43725_().f_46443_) {
                    CriterionMCA.GENERIC_EVENT_CRITERION.trigger((ServerPlayer)context.m_43723_(), cure ? "staffOfLife" : "scytheRevive");
                }
                if (!world.f_46443_ && !data.isResurrecting()) {
                    data.startResurrecting(cure);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }).orElse(InteractionResult.FAIL);
        }
        return InteractionResult.PASS;
    }
}

