/*
 * Decompiled with CFR 0.152.
 */
package mca.item;

import mca.Config;
import mca.entity.VillagerEntityMCA;
import mca.entity.ai.Memories;
import mca.entity.ai.Relationship;
import mca.entity.ai.relationship.CompassionateEntity;
import mca.item.SpecialCaseGift;
import mca.item.TooltippedItem;
import mca.server.world.data.PlayerSaveData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class WeddingRingItem
extends TooltippedItem
implements SpecialCaseGift {
    private final float heartsModifier;

    public WeddingRingItem(Item.Properties properties) {
        this(properties, 1.0f);
    }

    public WeddingRingItem(Item.Properties properties, float modifier) {
        super(properties);
        this.heartsModifier = modifier;
    }

    protected float getHeartsRequired() {
        return Config.getInstance().marriageHeartsRequirement * this.heartsModifier;
    }

    @Override
    public boolean handle(ServerPlayer player, VillagerEntityMCA villager) {
        String response;
        PlayerSaveData playerData = PlayerSaveData.get(player.m_183503_(), player.m_142081_());
        Memories memory = villager.getVillagerBrain().getMemoriesForPlayer((Player)player);
        boolean consume = false;
        if (villager.m_6162_()) {
            response = "interaction.marry.fail.isbaby";
        } else if (Relationship.IS_PARENT.test((CompassionateEntity<?>)villager, (Entity)player)) {
            response = "interaction.marry.fail.isparent";
        } else if (Relationship.IS_MARRIED.test((CompassionateEntity<?>)villager, (Entity)player)) {
            response = "interaction.marry.fail.marriedtogiver";
        } else if (villager.getRelationships().isMarried()) {
            response = "interaction.marry.fail.marriedtoother";
        } else if (playerData.isMarried()) {
            response = "interaction.marry.fail.playermarried";
        } else if ((float)memory.getHearts() < this.getHeartsRequired()) {
            response = "interaction.marry.fail.lowhearts";
        } else {
            response = "interaction.marry.success";
            playerData.marry((Entity)villager);
            villager.getRelationships().marry((Entity)player);
            villager.getVillagerBrain().modifyMoodValue(15);
            consume = true;
        }
        villager.sendChatMessage((Player)player, response, new Object[0]);
        return consume;
    }
}

