/*
 * Decompiled with CFR 0.152.
 */
package mca.network.c2s;

import java.util.Set;
import java.util.UUID;
import mca.client.gui.Constraint;
import mca.cobalt.network.Message;
import mca.cobalt.network.NetworkHandler;
import mca.entity.VillagerLike;
import mca.entity.ai.relationship.CompassionateEntity;
import mca.entity.ai.relationship.MarriageState;
import mca.entity.ai.relationship.family.FamilyTreeNode;
import mca.network.s2c.GetInteractDataResponse;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class GetInteractDataRequest
implements Message {
    private static final long serialVersionUID = -4363277735373237564L;
    UUID uuid;

    public GetInteractDataRequest(UUID villager) {
        this.uuid = villager;
    }

    @Override
    public void receive(ServerPlayer player) {
        Entity entity = player.m_183503_().m_8791_(this.uuid);
        if (entity instanceof VillagerLike) {
            VillagerLike villager = (VillagerLike)entity;
            Set<Constraint> constraints = Constraint.allMatching(villager, (Entity)player);
            Object relationship = ((CompassionateEntity)((Object)villager)).getRelationships();
            FamilyTreeNode family = relationship.getFamilyEntry();
            String fatherName = relationship.getFamilyTree().getOrEmpty(family.father()).map(FamilyTreeNode::getName).orElse(null);
            String motherName = relationship.getFamilyTree().getOrEmpty(family.mother()).map(FamilyTreeNode::getName).orElse(null);
            String spouseName = relationship.getFamilyTree().getOrEmpty(family.spouse()).map(FamilyTreeNode::getName).orElse(null);
            MarriageState marriageState = relationship.getMarriageState();
            NetworkHandler.sendToPlayer(new GetInteractDataResponse(constraints, fatherName, motherName, spouseName, marriageState), player);
        }
    }
}

