/*
 * Decompiled with CFR 0.152.
 */
package mca.resources;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mca.MCA;
import mca.resources.PoolUtil;
import mca.resources.Resources;
import mca.resources.VillageComponents;
import net.minecraft.server.packs.resources.ResourceManager;

public class API {
    static final Random rng = new Random();
    static Data instance = new Data();

    public static VillageComponents getVillagePool() {
        return API.instance.villageComponents;
    }

    public static String getRandomWord(String from) {
        return instance.pickWord(from);
    }

    public static String getRandomSentence(String from, int wordCount) {
        LinkedList<String> words = new LinkedList<String>();
        for (int i = 0; i < wordCount; ++i) {
            words.add(API.getRandomWord(from));
        }
        return String.join((CharSequence)" ", words);
    }

    public static String getRandomSentence(String from, String source) {
        int wordCount = source.split(" ").length;
        Object sentence = API.getRandomSentence(from, wordCount);
        char last = source.charAt(source.length() - 1);
        if (last == '!' || last == '?' || last == '.') {
            sentence = (String)sentence + last;
        }
        return sentence;
    }

    public static Random getRng() {
        return rng;
    }

    static class Data {
        final VillageComponents villageComponents = new VillageComponents(rng);
        private final Map<String, List<String>> words = new HashMap<String, List<String>>();

        Data() {
        }

        void init(ResourceManager manager) {
            try {
                this.villageComponents.load();
                this.words.put("zombie", Arrays.asList(Resources.read("api/names/zombie_words.json", String[].class)));
                this.words.put("baby", Arrays.asList(Resources.read("api/names/baby_words.json", String[].class)));
            }
            catch (Resources.BrokenResourceException e) {
                MCA.LOGGER.error("Could not load MCA resources", (Throwable)e);
            }
        }

        public String pickWord(String from) {
            return PoolUtil.pickOne(this.words.get(from), "?", rng);
        }
    }
}

