/*
 * Decompiled with CFR 0.152.
 */
package mca.resources.data.dialogue;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import mca.MCA;
import mca.cobalt.network.NetworkHandler;
import mca.entity.VillagerEntityMCA;
import mca.network.s2c.InteractionDialogueResponse;
import mca.resources.Dialogues;
import mca.resources.data.dialogue.Question;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;

public class Actions {
    public static final Map<String, Factory<JsonElement>> TYPES = new HashMap<String, Factory<JsonElement>>();
    private final List<Action> actions;
    private final boolean positive;

    public static <T> void register(String name, BiFunction<JsonElement, String, T> jsonParser, Factory<T> predicate) {
        TYPES.put(name, json -> predicate.parse(jsonParser.apply((JsonElement)json, name)));
    }

    public static Actions fromJson(JsonObject json) {
        LinkedList<Action> actions = new LinkedList<Action>();
        boolean positive = true;
        for (Map.Entry entry : json.entrySet()) {
            if (TYPES.containsKey(entry.getKey())) {
                Action parsed = TYPES.get(entry.getKey()).parse((JsonElement)entry.getValue());
                actions.add(parsed);
                if (!((String)entry.getKey()).equals("negative")) continue;
                positive = false;
                continue;
            }
            MCA.LOGGER.info("Unknown dialogue action " + (String)entry.getKey());
        }
        if (!json.has("next")) {
            Action parsed = TYPES.get("quit").parse((JsonElement)json);
            actions.add(parsed);
        }
        return new Actions(actions, positive);
    }

    public Actions(List<Action> actions, boolean positive) {
        this.actions = actions;
        this.positive = positive;
    }

    public void trigger(VillagerEntityMCA villager, ServerPlayer player) {
        for (Action c : this.actions) {
            c.trigger(villager, player);
        }
    }

    public boolean isPositive() {
        return this.positive;
    }

    static {
        Actions.register("next", GsonHelper::m_13805_, id -> (villager, player) -> {
            if (id != null) {
                Question newQuestion = Dialogues.getInstance().getRandomQuestion((String)id);
                if (newQuestion != null) {
                    if (newQuestion.isAuto()) {
                        Dialogues.getInstance().selectAnswer(villager, player, newQuestion.getId(), newQuestion.getAnswers().get(0).getName());
                        return;
                    }
                    NetworkHandler.sendToPlayer(new InteractionDialogueResponse(newQuestion, (Player)player, villager), player);
                } else {
                    villager.sendChatMessage((Player)player, "dialogue." + id, new Object[0]);
                }
                if (newQuestion == null || newQuestion.isCloseScreen()) {
                    villager.getInteractions().stopInteracting();
                }
            } else {
                villager.getInteractions().stopInteracting();
            }
        });
        Actions.register("quit", (a, b) -> a, id -> (villager, player) -> villager.getInteractions().stopInteracting());
        Actions.register("negative", GsonHelper::m_13897_, hearts -> (villager, player) -> {
            villager.getVillagerBrain().modifyMoodValue(-hearts.intValue());
            villager.getVillagerBrain().rewardHearts(player, -hearts.intValue());
        });
        Actions.register("positive", GsonHelper::m_13897_, hearts -> (villager, player) -> {
            villager.getVillagerBrain().modifyMoodValue((int)hearts);
            villager.getVillagerBrain().rewardHearts(player, (int)hearts);
        });
        Actions.register("command", GsonHelper::m_13805_, command -> (villager, player) -> villager.getInteractions().handle(player, (String)command));
    }

    public static interface Factory<T> {
        public Action parse(T var1);
    }

    public static interface Action {
        public void trigger(VillagerEntityMCA var1, ServerPlayer var2);
    }
}

