/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.pavocado.exoticbirds.blockentity.BirdcageBlockEntity;
import net.pavocado.exoticbirds.blockentity.misc.BirdcageLogic;
import net.pavocado.exoticbirds.init.ExoticBirdsBlockEntities;
import net.pavocado.exoticbirds.item.BirdcageItem;

public class BirdcageBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final VoxelShape CAGE_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0), (VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0));

    public BirdcageBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockState m_5573_(BlockPlaceContext placeContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)placeContext.m_8125_().m_122424_());
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return CAGE_SHAPE;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{FACING});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BirdcageBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> entityType) {
        return BirdcageBlock.m_152132_(entityType, (BlockEntityType)((BlockEntityType)ExoticBirdsBlockEntities.BIRDCAGE.get()), (BlockEntityTicker)(level.f_46443_ ? BirdcageBlockEntity::clientTick : BirdcageBlockEntity::serverTick));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity blockEntity;
        super.m_6402_(level, pos, state, entity, stack);
        if (!BirdcageItem.cageEmpty(stack) && (blockEntity = level.m_7702_(pos)) instanceof BirdcageBlockEntity) {
            ((BirdcageBlockEntity)blockEntity).getBirdcageLogic().setCageData(BirdcageItem.getCageData(stack));
        }
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!level.f_46443_ && blockEntity instanceof BirdcageBlockEntity) {
            BirdcageLogic birdcagelogic = ((BirdcageBlockEntity)blockEntity).getBirdcageLogic();
            birdcagelogic.spawnEntityViaExplosion((ServerLevel)level, pos, explosion);
        }
        super.onBlockExploded(state, level, pos, explosion);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BirdcageBlockEntity) {
            BirdcageLogic birdcage = ((BirdcageBlockEntity)blockEntity).getBirdcageLogic();
            ItemStack stack = new ItemStack((ItemLike)this.m_5456_());
            if (!player.m_36341_() || player.m_7500_()) {
                if (!level.f_46443_) {
                    birdcage.spawnEntity((ServerLevel)level, pos);
                }
                if (!player.m_7500_()) {
                    BirdcageBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack);
                }
            } else {
                CompoundTag cageData = birdcage.getCageData();
                if (cageData != null) {
                    stack.m_41700_("CageData", (Tag)cageData);
                }
                BirdcageBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack);
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        BirdcageLogic birdcage;
        CompoundTag cageData;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof BirdcageBlockEntity && (cageData = (birdcage = ((BirdcageBlockEntity)blockEntity).getBirdcageLogic()).getCageData()) != null && cageData.m_128425_("id", 8)) {
            ItemStack stack = new ItemStack((ItemLike)this.m_5456_());
            if (EntityType.m_20632_((String)cageData.m_128461_("id")).isPresent()) {
                EntityType entityType = (EntityType)EntityType.m_20632_((String)cageData.m_128461_("id")).get();
                SpawnEggItem spawneggitem = ForgeSpawnEggItem.fromEntityType((EntityType)entityType);
                return spawneggitem == null ? null : new ItemStack((ItemLike)spawneggitem);
            }
        }
        return super.getCloneItemStack(state, target, world, pos, player);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BirdcageBlockEntity) {
            return ((BirdcageBlockEntity)blockEntity).getBirdcageLogic().getCageData() != null ? 15 : 0;
        }
        return 0;
    }
}

