/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pavocado.exoticbirds.entity.CockatooEntity;

@OnlyIn(value=Dist.CLIENT)
public class CockatooModel<T extends CockatooEntity>
extends AgeableListModel<T> {
    public static final ModelLayerLocation COCKATOO_LAYER = new ModelLayerLocation(new ResourceLocation("exoticbirds", "cockatoo"), "main");
    private final ModelPart belly;
    private final ModelPart lowerBeak;
    private final ModelPart upperBeak;
    private final ModelPart tail;
    private final ModelPart tail2;
    private final ModelPart rightLeg;
    private final ModelPart leftFoot;
    private final ModelPart rightFoot;
    private final ModelPart rightWing;
    private final ModelPart leftWing;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart leftLeg;

    public CockatooModel(ModelPart part) {
        this.belly = part.m_171324_("belly");
        this.lowerBeak = part.m_171324_("lowerBeak");
        this.upperBeak = part.m_171324_("upperBeak");
        this.tail = part.m_171324_("tail");
        this.tail2 = part.m_171324_("tail2");
        this.rightLeg = part.m_171324_("rightLeg");
        this.leftFoot = part.m_171324_("leftFoot");
        this.rightFoot = part.m_171324_("rightFoot");
        this.rightWing = part.m_171324_("rightWing");
        this.leftWing = part.m_171324_("leftWing");
        this.body = part.m_171324_("body");
        this.head = part.m_171324_("head");
        this.leftLeg = part.m_171324_("leftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("belly", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171481_(-2.0f, 3.0f, -0.7f, 4.0f, 5.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)14.0f, (float)-3.0f, (float)0.2837967f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("lowerBeak", CubeListBuilder.m_171558_().m_171514_(16, 22).m_171481_(-0.5f, -1.8f, -3.4f, 1.0f, 1.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)15.0f, (float)-1.7f, (float)0.1487144f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("upperBeak", CubeListBuilder.m_171558_().m_171514_(14, 26).m_171481_(-1.0f, -3.6f, -3.5f, 2.0f, 2.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)15.0f, (float)-1.7f, (float)0.2602503f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(24, 24).m_171481_(-1.5f, 0.0f, 0.0f, 3.0f, 7.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)20.0f, (float)0.5f, (float)1.289716f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("tail2", CubeListBuilder.m_171558_().m_171514_(24, 24).m_171481_(-1.5f, 7.0f, 0.0f, 3.0f, 5.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)20.0f, (float)0.5f, (float)1.289716f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(16, 9).m_171481_(-0.5f, 0.0f, -0.5f, 1.0f, 3.0f, 1.0f), PartPose.m_171423_((float)-1.2f, (float)20.8f, (float)0.4f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftFoot", CubeListBuilder.m_171558_().m_171514_(15, 0).m_171481_(-1.0f, 3.0f, -2.4f, 2.0f, 0.0f, 4.0f), PartPose.m_171423_((float)1.2f, (float)20.8f, (float)0.4f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightFoot", CubeListBuilder.m_171558_().m_171514_(11, 0).m_171481_(-1.0f, 3.0f, -2.4f, 2.0f, 0.0f, 4.0f), PartPose.m_171423_((float)-1.2f, (float)20.8f, (float)0.4f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightWing", CubeListBuilder.m_171558_().m_171514_(22, 12).m_171481_(-1.0f, 0.0f, -1.0f, 1.0f, 8.0f, 4.0f), PartPose.m_171423_((float)-2.5f, (float)15.0f, (float)-2.0f, (float)0.5235988f, (float)0.122173f, (float)0.0f));
        partdefinition.m_171599_("leftWing", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171481_(0.0f, 0.0f, -1.0f, 1.0f, 8.0f, 4.0f), PartPose.m_171423_((float)2.5f, (float)15.0f, (float)-2.0f, (float)0.5235988f, (float)-0.122173f, (float)0.0f));
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.5f, 0.0f, -1.0f, 5.0f, 4.0f, 5.0f), PartPose.m_171423_((float)0.0f, (float)14.0f, (float)-3.0f, (float)0.2094395f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(16, 13).m_171481_(-0.5f, 0.0f, -0.5f, 1.0f, 3.0f, 1.0f), PartPose.m_171423_((float)1.2f, (float)20.8f, (float)0.4f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headDefinition = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171481_(-2.0f, -4.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)15.0f, (float)-1.7f, (float)0.0872665f, (float)0.0f, (float)0.0f));
        headDefinition.m_171599_("quiff", CubeListBuilder.m_171558_().m_171514_(12, 14).m_171481_(0.0f, -4.5f, 0.0f, 0.0f, 4.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)-3.8f, (float)-2.0f, (float)-0.26f, (float)0.0f, (float)0.0f));
        headDefinition.m_171599_("crest", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171481_(-1.5f, 0.0f, 0.0f, 3.0f, 2.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)-3.8f, (float)-2.0f, (float)1.1f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.lowerBeak, (Object)this.upperBeak, (Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.belly, (Object)this.tail, (Object)this.tail2, (Object)this.rightLeg, (Object)this.leftFoot, (Object)this.rightFoot, (Object)this.rightWing, (Object)this.leftWing, (Object)this.body, (Object)this.leftLeg);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.upperBeak.f_104204_ = this.head.f_104204_ = netHeadYaw / 57.295776f;
        this.lowerBeak.f_104204_ = this.head.f_104204_;
        this.rightFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * 1.0f)) * 1.4f * limbSwingAmount;
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 1.0f)) * 1.4f * limbSwingAmount;
        this.leftFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * 1.0f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 1.0f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.tail.f_104203_ = 1.289716f;
        this.tail2.f_104203_ = 1.289716f;
        this.leftWing.f_104205_ = -ageInTicks;
        this.rightWing.f_104205_ = ageInTicks;
    }

    public void m_7695_(PoseStack stack, VertexConsumer builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            stack.m_85836_();
            stack.m_85841_(0.5f, 0.5f, 0.5f);
            stack.m_85837_(0.0, 1.5, 0.0);
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            stack.m_85849_();
        } else {
            stack.m_85836_();
            stack.m_85841_(0.95f, 0.95f, 0.95f);
            stack.m_85837_(0.0, 0.09, 0.0);
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            stack.m_85849_();
        }
    }
}

