/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pavocado.exoticbirds.entity.DuckEntity;

@OnlyIn(value=Dist.CLIENT)
public class DuckModel<T extends DuckEntity>
extends AgeableListModel<T> {
    public static final ModelLayerLocation DUCK_LAYER = new ModelLayerLocation(new ResourceLocation("exoticbirds", "duck"), "main");
    private final ModelPart body;
    private final ModelPart back;
    private final ModelPart tail;
    private final ModelPart breast;
    private final ModelPart beak;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart rightFoot;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart leftFoot;
    private final ModelPart rightWing;
    private final ModelPart leftWing;

    public DuckModel(ModelPart part) {
        this.body = part.m_171324_("body");
        this.back = part.m_171324_("back");
        this.tail = part.m_171324_("tail");
        this.breast = part.m_171324_("breast");
        this.beak = part.m_171324_("beak");
        this.neck = part.m_171324_("neck");
        this.head = part.m_171324_("head");
        this.rightFoot = part.m_171324_("rightFoot");
        this.rightLeg = part.m_171324_("rightLeg");
        this.leftLeg = part.m_171324_("leftLeg");
        this.leftFoot = part.m_171324_("leftFoot");
        this.rightWing = part.m_171324_("rightWing");
        this.leftWing = part.m_171324_("leftWing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.5f, 0.0f, 0.0f, 5.0f, 5.0f, 5.0f), PartPose.m_171423_((float)0.0f, (float)17.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("back", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-2.0f, -0.5f, 0.0f, 4.0f, 4.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)18.0f, (float)1.5f, (float)-0.2617994f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171481_(-1.5f, 0.0f, 0.0f, 3.0f, 2.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)19.7f, (float)1.8f, (float)0.3839724f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("breast", CubeListBuilder.m_171558_().m_171514_(0, 10).m_171481_(-2.0f, 0.0f, 0.0f, 4.0f, 4.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)17.0f, (float)-4.0f, (float)-0.1858931f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("beak", CubeListBuilder.m_171558_().m_171514_(20, 7).m_171481_(-1.0f, -2.5f, -4.8f, 2.0f, 1.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)17.0f, (float)-3.5f, (float)0.1487144f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171481_(-1.0f, -1.6f, -1.0f, 2.0f, 3.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)17.0f, (float)-3.5f, (float)-0.2443461f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(20, 0).m_171481_(-1.5f, -3.8f, -2.5f, 3.0f, 3.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)17.0f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightFoot", CubeListBuilder.m_171558_().m_171514_(12, 17).m_171481_(-1.0f, 3.0f, -2.0f, 2.0f, 0.0f, 3.0f), PartPose.m_171423_((float)-1.0f, (float)21.0f, (float)-0.6f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(16, 10).m_171481_(-0.5f, 0.0f, -0.5f, 1.0f, 3.0f, 1.0f), PartPose.m_171423_((float)-1.0f, (float)21.0f, (float)-0.6f, (float)-0.0698132f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(12, 10).m_171481_(-0.5f, 0.0f, -0.5f, 1.0f, 3.0f, 1.0f), PartPose.m_171423_((float)1.0f, (float)21.0f, (float)-0.6f, (float)-0.0698132f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftFoot", CubeListBuilder.m_171558_().m_171514_(12, 14).m_171481_(-1.0f, 3.0f, -2.0f, 2.0f, 0.0f, 3.0f), PartPose.m_171423_((float)1.0f, (float)21.0f, (float)-0.6f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightWing", CubeListBuilder.m_171558_().m_171514_(26, 22).m_171481_(-1.0f, -1.0f, -1.0f, 1.0f, 4.0f, 6.0f), PartPose.m_171423_((float)-2.0f, (float)18.0f, (float)-2.0f, (float)-0.0872665f, (float)0.0349066f, (float)0.1396263f));
        partdefinition.m_171599_("leftWing", CubeListBuilder.m_171558_().m_171514_(12, 22).m_171481_(0.0f, -1.0f, -1.0f, 1.0f, 4.0f, 6.0f), PartPose.m_171423_((float)2.0f, (float)18.0f, (float)-2.0f, (float)-0.0872665f, (float)-0.0349066f, (float)-0.1396263f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.beak, (Object)this.neck, (Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.back, (Object)this.tail, (Object)this.breast, (Object)this.rightFoot, (Object)this.rightLeg, (Object)this.leftLeg, (Object)this.leftFoot, (Object)this.rightWing, (Object)this.leftWing);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104203_ = -(headPitch / 57.295776f);
        this.head.f_104204_ = netHeadYaw / 57.295776f;
        this.beak.f_104203_ = -(headPitch / 57.295776f) + 0.1487144f;
        this.beak.f_104204_ = netHeadYaw / 57.295776f;
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * limbSwingAmount - 0.0698132f;
        this.rightFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount - 0.0698132f;
        this.leftFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.rightWing.f_104205_ = ageInTicks;
        this.leftWing.f_104205_ = -ageInTicks;
    }

    public void m_7695_(PoseStack stack, VertexConsumer builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            stack.m_85836_();
            stack.m_85841_(0.55f, 0.55f, 0.55f);
            stack.m_85837_(0.0, 1.2, 0.0);
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            stack.m_85849_();
        } else {
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
        }
    }
}

