/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.entity;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.pavocado.exoticbirds.entity.AbstractBirdEntity;
import net.pavocado.exoticbirds.init.ExoticBirdsEntities;

public abstract class AbstractSwimmingBirdEntity
extends AbstractBirdEntity {
    public AbstractSwimmingBirdEntity(EntityType<? extends AbstractBirdEntity> type, Level levelIn, ItemStack eggIn, int typeCountIn, boolean canFloatIn, boolean genderedIn) {
        super(type, levelIn, eggIn, typeCountIn, canFloatIn, genderedIn);
        this.m_21573_().m_7008_(true);
    }

    @Override
    public MobType m_6336_() {
        return ExoticBirdsEntities.WATER_BIRD;
    }

    public boolean canStandOnFluid(Fluid p_33893_) {
        return p_33893_.m_205067_(FluidTags.f_13131_);
    }

    public void m_8119_() {
        super.m_8119_();
        this.floatEntity();
        this.m_20101_();
        this.m_7910_((float)this.m_21133_(Attributes.f_22279_) * (this.m_20069_() ? 0.8f : 1.0f));
    }

    protected void floatEntity() {
        if (this.m_20069_()) {
            CollisionContext collisioncontext = CollisionContext.m_82750_((Entity)this);
            if (collisioncontext.m_6513_(LiquidBlock.f_54690_, this.m_142538_(), true) && !this.f_19853_.m_6425_(this.m_142538_().m_7494_()).m_205070_(FluidTags.f_13131_)) {
                this.f_19861_ = true;
            } else {
                this.m_20256_(this.m_20184_().m_82490_(0.5).m_82520_(0.0, 0.05, 0.0));
            }
        }
    }

    protected PathNavigation m_6037_(Level level) {
        return new SwimmingBirdPathNavigation(this, level);
    }

    public static boolean checkSwimmingBirdSpawnRules(EntityType<? extends AbstractSwimmingBirdEntity> bird, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, Random rand) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.m_122032_();
        do {
            blockpos$mutableblockpos.m_122173_(Direction.UP);
        } while (level.m_6425_((BlockPos)blockpos$mutableblockpos).m_205070_(FluidTags.f_13131_));
        return level.m_8055_((BlockPos)blockpos$mutableblockpos).m_60795_() && AbstractSwimmingBirdEntity.m_186209_((BlockAndTintGetter)level, (BlockPos)pos);
    }

    static class SwimmingBirdPathNavigation
    extends GroundPathNavigation {
        SwimmingBirdPathNavigation(AbstractBirdEntity entity, Level level) {
            super((Mob)entity, level);
        }

        protected PathFinder m_5532_(int p_33972_) {
            this.f_26508_ = new WalkNodeEvaluator();
            return new PathFinder(this.f_26508_, p_33972_);
        }

        protected boolean m_7367_(BlockPathTypes pathTypes) {
            return pathTypes == BlockPathTypes.WATER || super.m_7367_(pathTypes);
        }

        public boolean m_6342_(BlockPos p_33976_) {
            return this.f_26495_.m_8055_(p_33976_).m_60713_(Blocks.f_49990_) || super.m_6342_(p_33976_);
        }
    }
}

