/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.entity;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.pavocado.exoticbirds.block.HummingbirdFeederBlock;
import net.pavocado.exoticbirds.config.ExoticBirdsCommonConfig;
import net.pavocado.exoticbirds.entity.AbstractFlyingBirdEntity;
import net.pavocado.exoticbirds.init.ExoticBirdsBlocks;
import net.pavocado.exoticbirds.init.ExoticBirdsEntities;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;

public class HummingbirdEntity
extends AbstractFlyingBirdEntity {
    int moreFeederTicks;
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42501_});
    private static final Map<Integer, ResourceLocation> BIRD_TEXTURES = (Map)Util.m_137469_((Object)Maps.newHashMap(), hashMap -> {
        hashMap.put(0, new ResourceLocation("exoticbirds:textures/entity/hummingbird/hummingbird_blue.png"));
        hashMap.put(1, new ResourceLocation("exoticbirds:textures/entity/hummingbird/hummingbird_green.png"));
        hashMap.put(2, new ResourceLocation("exoticbirds:textures/entity/hummingbird/hummingbird_purple.png"));
        hashMap.put(3, new ResourceLocation("exoticbirds:textures/entity/hummingbird/hummingbird_red.png"));
        hashMap.put(4, new ResourceLocation("exoticbirds:textures/entity/hummingbird/hummingbird_yellow.png"));
    });

    public HummingbirdEntity(EntityType<? extends HummingbirdEntity> type, Level level) {
        super(type, level, new ItemStack((ItemLike)ExoticBirdsItems.HUMMINGBIRD_EGG.get()), BIRD_TEXTURES.size(), false);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42501_}), false));
        this.f_21345_.m_25352_(2, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new FeedOnFeederGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new WanderGoal());
        this.f_21345_.m_25352_(5, (Goal)new FloatGoal((Mob)this));
    }

    @Override
    public void m_7380_(CompoundTag p_29697_) {
        super.m_7380_(p_29697_);
        p_29697_.m_128405_("MoreFeederTicks", this.moreFeederTicks);
    }

    @Override
    public void m_7378_(CompoundTag p_29684_) {
        super.m_7378_(p_29684_);
        this.moreFeederTicks = p_29684_.m_128451_("MoreFeederTicks");
    }

    protected float m_6431_(Pose poseIn, EntityDimensions size) {
        return size.f_20378_ * 0.8f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 2.0).m_22268_(Attributes.f_22279_, 0.1).m_22268_(Attributes.f_22280_, 1.0);
    }

    @Override
    protected Map<Integer, ResourceLocation> getEntityTextures() {
        return BIRD_TEXTURES;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_11754_, 0.15f, 1.0f);
    }

    public HummingbirdEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        HummingbirdEntity hummingbird = (HummingbirdEntity)((EntityType)ExoticBirdsEntities.HUMMINGBIRD.get()).m_20615_((Level)serverLevel);
        hummingbird.setVariant(this.getChildVariant());
        return hummingbird;
    }

    @Override
    protected void performFlap() {
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed = (float)((double)this.flapSpeed + 1.2);
        this.flapSpeed = Mth.m_14036_((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        this.flapping = 1.0f;
        this.flap += this.flapping * 2.0f;
    }

    @Override
    public void m_8024_() {
        if (this.moreFeederTicks > 0) {
            this.moreFeederTicks -= this.f_19796_.nextInt(3);
            if (this.moreFeederTicks < 0) {
                this.moreFeederTicks = 0;
            }
        }
    }

    public boolean m_6898_(ItemStack stack) {
        return FOOD_ITEMS.test(stack);
    }

    @Override
    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level){

            public boolean m_6342_(BlockPos pos) {
                return !this.f_26495_.m_8055_(pos.m_7495_()).m_60795_();
            }
        };
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(false);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    @Override
    public List<String> getBlacklistedDimensions() {
        return (List)ExoticBirdsCommonConfig.blacklistedDimensionsHummingbird.get();
    }

    @Override
    public List<ItemStack> getTemptingItems() {
        return Arrays.asList(FOOD_ITEMS.m_43908_());
    }

    static class FeedOnFeederGoal
    extends MoveToBlockGoal {
        private final HummingbirdEntity hummingbird;
        private boolean wantsToEat;
        private boolean canEat;

        public FeedOnFeederGoal(HummingbirdEntity p_29782_) {
            super((PathfinderMob)p_29782_, (double)0.7f, 16, 6);
            this.hummingbird = p_29782_;
        }

        public boolean m_8036_() {
            if (this.f_25600_ <= 0) {
                this.canEat = false;
                this.wantsToEat = this.hummingbird.moreFeederTicks == 0;
            }
            return super.m_8036_();
        }

        protected BlockPos m_6669_() {
            return this.f_25602_;
        }

        public boolean m_8045_() {
            return this.canEat && super.m_8045_();
        }

        public void m_8037_() {
            super.m_8037_();
            this.hummingbird.m_21563_().m_24950_((double)this.f_25602_.m_123341_() + 0.5, (double)(this.f_25602_.m_123342_() + 1), (double)this.f_25602_.m_123343_() + 0.5, 10.0f, (float)this.hummingbird.m_8132_());
            if (this.m_25625_()) {
                Level level = this.hummingbird.f_19853_;
                BlockPos blockpos = this.f_25602_;
                BlockState blockstate = level.m_8055_(blockpos);
                Block block = blockstate.m_60734_();
                if (this.canEat && block instanceof HummingbirdFeederBlock) {
                    int i = (Integer)blockstate.m_61143_((Property)HummingbirdFeederBlock.LEVEL);
                    if (i > 0) {
                        level.m_7731_(blockpos, (BlockState)blockstate.m_61124_((Property)HummingbirdFeederBlock.LEVEL, (Comparable)Integer.valueOf(i - 1)), 2);
                        this.hummingbird.m_5634_(1.0f);
                    }
                    this.hummingbird.moreFeederTicks = 40;
                }
                this.canEat = false;
                this.f_25600_ = 10;
            }
        }

        protected boolean m_6465_(LevelReader p_29785_, BlockPos p_29786_) {
            BlockState blockstate = p_29785_.m_8055_(p_29786_);
            if (blockstate.m_60713_((Block)ExoticBirdsBlocks.HUMMINGBIRD_FEEDER.get()) && this.wantsToEat && !this.canEat && (Integer)blockstate.m_61143_((Property)HummingbirdFeederBlock.LEVEL) > 0) {
                this.canEat = true;
                return true;
            }
            return false;
        }
    }

    class WanderGoal
    extends Goal {
        WanderGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return HummingbirdEntity.this.f_21344_.m_26571_() && HummingbirdEntity.this.f_19796_.nextInt(10) == 0;
        }

        public boolean m_8045_() {
            return HummingbirdEntity.this.f_21344_.m_26572_();
        }

        public void m_8056_() {
            Vec3 vec3d = this.getTargetPosition();
            if (vec3d != null) {
                HummingbirdEntity.this.f_21344_.m_26536_(HummingbirdEntity.this.f_21344_.m_7864_(new BlockPos(vec3d), 1), 1.0);
            }
        }

        @Nullable
        private Vec3 getTargetPosition() {
            Vec3 vec3 = HummingbirdEntity.this.m_20252_(0.0f);
            Vec3 vec32 = HoverRandomPos.m_148465_((PathfinderMob)HummingbirdEntity.this, (int)8, (int)7, (double)vec3.f_82479_, (double)vec3.f_82481_, (float)1.5707964f, (int)3, (int)1);
            return vec32 != null ? vec32 : AirAndWaterRandomPos.m_148357_((PathfinderMob)HummingbirdEntity.this, (int)8, (int)4, (int)-2, (double)vec3.f_82479_, (double)vec3.f_82481_, (double)1.5707963705062866);
        }
    }
}

