/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import dev.tr7zw.skinlayers.render.CustomizableCube;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;

public class CustomizableModelPart {
    public float x;
    public float y;
    public float z;
    public float xRot;
    public float yRot;
    public float zRot;
    public boolean visible = true;
    private final List<ModelPart.Cube> cubes;
    private final Map<String, ModelPart> children;
    private float[] polygonData = null;
    private int polygonAmount = 0;
    private final int polyDataSize = 23;

    public CustomizableModelPart(List<ModelPart.Cube> list, List<CustomizableCube> customCubes, Map<String, ModelPart> map) {
        this.cubes = list;
        this.children = map;
        this.compactCubes(customCubes);
    }

    private void compactCubes(List<CustomizableCube> customCubes) {
        for (CustomizableCube cube : customCubes) {
            this.polygonAmount += cube.polygonCount;
        }
        this.polygonData = new float[this.polygonAmount * 23];
        int offset = 0;
        for (CustomizableCube cube : customCubes) {
            for (int id = 0; id < cube.polygonCount; ++id) {
                CustomizableCube.Polygon polygon = cube.polygons[id];
                Vector3f vector3f = polygon.normal;
                this.polygonData[offset + 0] = vector3f.m_122239_();
                this.polygonData[offset + 1] = vector3f.m_122260_();
                this.polygonData[offset + 2] = vector3f.m_122269_();
                for (int i = 0; i < 4; ++i) {
                    CustomizableCube.Vertex vertex = polygon.vertices[i];
                    this.polygonData[offset + 3 + i * 5 + 0] = vertex.scaledX;
                    this.polygonData[offset + 3 + i * 5 + 1] = vertex.scaledY;
                    this.polygonData[offset + 3 + i * 5 + 2] = vertex.scaledZ;
                    this.polygonData[offset + 3 + i * 5 + 3] = vertex.u;
                    this.polygonData[offset + 3 + i * 5 + 4] = vertex.v;
                }
                offset += 23;
            }
        }
    }

    public void loadPose(PartPose partPose) {
        this.x = partPose.f_171405_;
        this.y = partPose.f_171406_;
        this.z = partPose.f_171407_;
        this.xRot = partPose.f_171408_;
        this.yRot = partPose.f_171409_;
        this.zRot = partPose.f_171410_;
    }

    public void copyFrom(ModelPart modelPart) {
        this.xRot = modelPart.f_104203_;
        this.yRot = modelPart.f_104204_;
        this.zRot = modelPart.f_104205_;
        this.x = modelPart.f_104200_;
        this.y = modelPart.f_104201_;
        this.z = modelPart.f_104202_;
    }

    public ModelPart getChild(String string) {
        ModelPart modelPart = this.children.get(string);
        if (modelPart == null) {
            throw new NoSuchElementException("Can't find part " + string);
        }
        return modelPart;
    }

    public void setPos(float f, float g, float h) {
        this.x = f;
        this.y = g;
        this.z = h;
    }

    public void setRotation(float f, float g, float h) {
        this.xRot = f;
        this.yRot = g;
        this.zRot = h;
    }

    public void render(PoseStack poseStack, VertexConsumer vertexConsumer, int i, int j) {
        this.render(poseStack, vertexConsumer, i, j, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void render(PoseStack poseStack, VertexConsumer vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        if (!this.visible) {
            return;
        }
        poseStack.m_85836_();
        this.translateAndRotate(poseStack);
        this.compile(poseStack.m_85850_(), vertexConsumer, light, overlay, red, green, blue, alpha);
        for (ModelPart modelPart : this.children.values()) {
            modelPart.m_104306_(poseStack, vertexConsumer, light, overlay, red, green, blue, alpha);
        }
        poseStack.m_85849_();
    }

    public void translateAndRotate(PoseStack poseStack) {
        poseStack.m_85837_((double)(this.x / 16.0f), (double)(this.y / 16.0f), (double)(this.z / 16.0f));
        if (this.zRot != 0.0f) {
            poseStack.m_85845_(Vector3f.f_122227_.m_122270_(this.zRot));
        }
        if (this.yRot != 0.0f) {
            poseStack.m_85845_(Vector3f.f_122225_.m_122270_(this.yRot));
        }
        if (this.xRot != 0.0f) {
            poseStack.m_85845_(Vector3f.f_122223_.m_122270_(this.xRot));
        }
    }

    private void compile(PoseStack.Pose pose, VertexConsumer vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        Matrix4f matrix4f = pose.m_85861_();
        Matrix3f matrix3f = pose.m_85864_();
        Vector3f vector3f = new Vector3f();
        Vector4f vector4f = new Vector4f();
        for (int id = 0; id < this.polygonData.length; id += 23) {
            vector3f.m_122245_(this.polygonData[id + 0], this.polygonData[id + 1], this.polygonData[id + 2]);
            vector3f.m_122249_(matrix3f);
            for (int o = 0; o < 4; ++o) {
                vector4f.m_123602_(this.polygonData[id + 3 + o * 5 + 0], this.polygonData[id + 3 + o * 5 + 1], this.polygonData[id + 3 + o * 5 + 2], 1.0f);
                vector4f.m_123607_(matrix4f);
                vertexConsumer.m_5954_(vector4f.m_123601_(), vector4f.m_123615_(), vector4f.m_123616_(), red, green, blue, alpha, this.polygonData[id + 3 + o * 5 + 3], this.polygonData[id + 3 + o * 5 + 4], overlay, light, vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_());
            }
        }
        for (ModelPart.Cube cube : this.cubes) {
            cube.m_171332_(pose, vertexConsumer, light, overlay, red, green, blue, alpha);
        }
    }
}

