/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.render;

import com.mojang.blaze3d.platform.NativeImage;
import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.render.CustomizableCube;
import dev.tr7zw.skinlayers.render.CustomizableCubeListBuilder;
import dev.tr7zw.skinlayers.render.CustomizableModelPart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.Direction;

public class SolidPixelWrapper {
    private static final float pixelSize = 1.0f;

    public static CustomizableModelPart wrapBox(NativeImage natImage, int width, int height, int depth, int textureU, int textureV, boolean topPivot, float rotationOffset) {
        CustomizableCubeListBuilder cubes = CustomizableCubeListBuilder.create();
        float staticXOffset = (float)(-width) / 2.0f;
        float staticYOffset = topPivot ? rotationOffset : (float)(-height) + rotationOffset;
        float staticZOffset = (float)(-depth) / 2.0f;
        Position staticOffset = new Position(staticXOffset, staticYOffset, staticZOffset);
        Dimensions dimensions = new Dimensions(width, height, depth);
        UV textureUV = new UV(textureU, textureV);
        try {
            for (Direction face : Direction.values()) {
                UV sizeUV = SolidPixelWrapper.getSizeUV(dimensions, face);
                for (int u = 0; u < sizeUV.u; ++u) {
                    for (int v = 0; v < sizeUV.v; ++v) {
                        SolidPixelWrapper.addPixel(natImage, cubes, staticOffset, face, dimensions, new UV(u, v), textureUV, sizeUV);
                    }
                }
            }
        }
        catch (Exception ex) {
            SkinLayersModBase.LOGGER.error("Error while creating 3d skin model. Please report on the Github/Discord.", (Throwable)ex);
            return new CustomizableModelPart(new ArrayList<ModelPart.Cube>(), new ArrayList<CustomizableCube>(), new HashMap<String, ModelPart>());
        }
        if (SkinLayersModBase.config.fastRender && !cubes.getCubes().isEmpty()) {
            cubes.uv(textureU, textureV).addVanillaBox(staticXOffset, staticYOffset, staticZOffset, width, height, depth, 1.0f);
        }
        return new CustomizableModelPart(cubes.getVanillaCubes(), cubes.getCubes(), new HashMap<String, ModelPart>());
    }

    private static UV getSizeUV(Dimensions dimensions, Direction face) {
        return switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN, Direction.UP -> new UV(dimensions.width, dimensions.depth);
            case Direction.NORTH, Direction.SOUTH -> new UV(dimensions.width, dimensions.height);
            case Direction.WEST, Direction.EAST -> new UV(dimensions.depth, dimensions.height);
        };
    }

    private static UV getOnTextureUV(UV textureUV, UV onFaceUV, Dimensions dimensions, Direction face) {
        return switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> new UV(textureUV.u + dimensions.depth + onFaceUV.u, textureUV.v + onFaceUV.v);
            case Direction.UP -> new UV(textureUV.u + dimensions.width + dimensions.depth + onFaceUV.u, textureUV.v + onFaceUV.v);
            case Direction.NORTH -> new UV(textureUV.u + dimensions.depth + onFaceUV.u, textureUV.v + dimensions.depth + onFaceUV.v);
            case Direction.SOUTH -> new UV(textureUV.u + dimensions.depth + dimensions.width + dimensions.depth + onFaceUV.u, textureUV.v + dimensions.depth + onFaceUV.v);
            case Direction.WEST -> new UV(textureUV.u + onFaceUV.u, textureUV.v + dimensions.depth + onFaceUV.v);
            case Direction.EAST -> new UV(textureUV.u + dimensions.depth + dimensions.width + onFaceUV.u, textureUV.v + dimensions.depth + onFaceUV.v);
        };
    }

    private static VoxelPosition UVtoXYZ(UV onFaceUV, Dimensions dimensions, Direction face) {
        return switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> new VoxelPosition(onFaceUV.u, 0, dimensions.depth - 1 - onFaceUV.v);
            case Direction.UP -> new VoxelPosition(onFaceUV.u, dimensions.height - 1, dimensions.depth - 1 - onFaceUV.v);
            case Direction.NORTH -> new VoxelPosition(onFaceUV.u + 0, onFaceUV.v, 0);
            case Direction.SOUTH -> new VoxelPosition(dimensions.width - 1 - onFaceUV.u, onFaceUV.v, dimensions.depth - 1);
            case Direction.WEST -> new VoxelPosition(0, onFaceUV.v, dimensions.depth - 1 - onFaceUV.u);
            case Direction.EAST -> new VoxelPosition(dimensions.width - 1, onFaceUV.v, onFaceUV.u + 0);
        };
    }

    private static UV XYZtoUV(VoxelPosition voxelPosition, Dimensions dimensions, Direction face) {
        return switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN, Direction.UP -> new UV(voxelPosition.x, dimensions.depth - 1 - voxelPosition.z);
            case Direction.NORTH -> new UV(voxelPosition.x + 0, voxelPosition.y);
            case Direction.SOUTH -> new UV(dimensions.width - 1 - voxelPosition.x, voxelPosition.y);
            case Direction.WEST -> new UV(dimensions.depth - 1 - voxelPosition.z, voxelPosition.y);
            case Direction.EAST -> new UV(voxelPosition.z + 0, voxelPosition.y);
        };
    }

    private static void addPixel(NativeImage natImage, CustomizableCubeListBuilder cubes, Position staticOffset, Direction face, Dimensions dimensions, UV onFaceUV, UV textureUV, UV sizeUV) {
        UV onTextureUV = SolidPixelWrapper.getOnTextureUV(textureUV, onFaceUV, dimensions, face);
        if (!SolidPixelWrapper.isPresent(natImage, onTextureUV)) {
            return;
        }
        VoxelPosition voxelPosition = SolidPixelWrapper.UVtoXYZ(onFaceUV, dimensions, face);
        Position position = new Position(staticOffset.x + (float)voxelPosition.x, staticOffset.y + (float)voxelPosition.y, staticOffset.z + (float)voxelPosition.z);
        boolean solidPixel = SolidPixelWrapper.isSolid(natImage, onTextureUV);
        HashSet<Direction> hide = new HashSet<Direction>();
        HashSet<Direction[]> corners = new HashSet<Direction[]>();
        boolean isOnBorder = false;
        boolean backsideOverlaps = false;
        for (Direction neighbourFace : Direction.values()) {
            if (neighbourFace.m_122434_() == face.m_122434_()) continue;
            VoxelPosition neighbourVoxelPosition = new VoxelPosition(voxelPosition.x + neighbourFace.m_122429_(), voxelPosition.y + neighbourFace.m_122430_(), voxelPosition.z + neighbourFace.m_122431_());
            UV neighbourOnFaceUV = SolidPixelWrapper.XYZtoUV(neighbourVoxelPosition, dimensions, face);
            if (SolidPixelWrapper.isOnFace(neighbourOnFaceUV, sizeUV)) {
                if (SolidPixelWrapper.isPresent(natImage, SolidPixelWrapper.getOnTextureUV(textureUV, neighbourOnFaceUV, dimensions, face))) {
                    if (solidPixel && !SolidPixelWrapper.isSolid(natImage, SolidPixelWrapper.getOnTextureUV(textureUV, neighbourOnFaceUV, dimensions, face))) continue;
                    hide.add(neighbourFace);
                    continue;
                }
                VoxelPosition farNeighbourVoxelPosition = new VoxelPosition(neighbourVoxelPosition.x + neighbourFace.m_122429_(), neighbourVoxelPosition.y + neighbourFace.m_122430_(), neighbourVoxelPosition.z + neighbourFace.m_122431_());
                UV farNeighbourOnFaceUV = SolidPixelWrapper.XYZtoUV(farNeighbourVoxelPosition, dimensions, face);
                if (SolidPixelWrapper.isOnFace(farNeighbourOnFaceUV, sizeUV) || !SolidPixelWrapper.isPresent(natImage, SolidPixelWrapper.getOnTextureUV(textureUV, farNeighbourOnFaceUV = SolidPixelWrapper.XYZtoUV(farNeighbourVoxelPosition, dimensions, neighbourFace), dimensions, neighbourFace)) || solidPixel && !SolidPixelWrapper.isSolid(natImage, SolidPixelWrapper.getOnTextureUV(textureUV, farNeighbourOnFaceUV, dimensions, neighbourFace))) continue;
                hide.add(neighbourFace);
                continue;
            }
            isOnBorder = true;
            neighbourOnFaceUV = SolidPixelWrapper.XYZtoUV(voxelPosition, dimensions, neighbourFace);
            if (SolidPixelWrapper.isPresent(natImage, SolidPixelWrapper.getOnTextureUV(textureUV, neighbourOnFaceUV, dimensions, neighbourFace))) {
                backsideOverlaps = true;
                hide.add(neighbourFace);
                corners.add(new Direction[]{face.m_122424_(), neighbourFace});
                continue;
            }
            UV downNeighbourOnFaceUV = SolidPixelWrapper.XYZtoUV(new VoxelPosition(voxelPosition.x - face.m_122429_(), voxelPosition.y - face.m_122430_(), voxelPosition.z - face.m_122431_()), dimensions, neighbourFace);
            if (!SolidPixelWrapper.isPresent(natImage, SolidPixelWrapper.getOnTextureUV(textureUV, downNeighbourOnFaceUV, dimensions, neighbourFace))) continue;
            backsideOverlaps = true;
        }
        if (!isOnBorder || backsideOverlaps) {
            hide.add(face.m_122424_());
        }
        if (SkinLayersModBase.config.fastRender) {
            hide.add(face);
        }
        cubes.uv(onTextureUV.u, onTextureUV.v).addBox(position.x, position.y, position.z, 1.0f, (Direction[])hide.toArray(Direction[]::new), (Direction[][])corners.toArray(x$0 -> new Direction[x$0][]));
    }

    private static boolean isPresent(NativeImage natImage, UV onTextureUV) {
        return natImage.m_85087_(onTextureUV.u, onTextureUV.v) != 0;
    }

    private static boolean isSolid(NativeImage natImage, UV onTextureUV) {
        return natImage.m_85087_(onTextureUV.u, onTextureUV.v) == -1;
    }

    private static boolean isOnFace(UV onFaceUV, UV sizeUV) {
        return onFaceUV.u >= 0 && onFaceUV.u < sizeUV.u && onFaceUV.v >= 0 && onFaceUV.v < sizeUV.v;
    }

    public record Position(float x, float y, float z) {
    }

    public record Dimensions(int width, int height, int depth) {
    }

    public record UV(int u, int v) {
    }

    public record VoxelPosition(int x, int y, int z) {
    }
}

