/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.marg.client.generators.textures.generator;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.KeyDispatchCodec;
import com.mojang.serialization.codecs.PairCodec;
import java.util.function.BiFunction;
import net.dark_roleplay.marg.client.generators.textures.generator.processors.TextureProcessorData;
import net.dark_roleplay.marg.client.generators.textures.generator.processors.TextureProcessors;
import net.dark_roleplay.marg.client.generators.textures.texture.TextureData;
import net.dark_roleplay.marg.util.EnumDecoder;

public class TextureGeneratorManipulation {
    public static final Codec<TextureGeneratorManipulation> CODEC = new PairCodec(ManipulationType.CODEC.fieldOf("type").codec(), KeyDispatchCodec.unsafe((String)"type", (Codec)Codec.STRING, data -> DataResult.error((String)"Cannot convert TextureProcessorData Codec back to type"), type -> DataResult.success(TextureProcessorData.getCodecForType(type)), type -> DataResult.error((String)"Cannot encode TextureProcessorData")).codec()).xmap(TextureGeneratorManipulation::new, val -> Pair.of((Object)((Object)val.getManipulationType()), (Object)val.getData()));
    private final ManipulationType manipulationType;
    private final TextureProcessorData data;

    public TextureGeneratorManipulation(Pair<ManipulationType, TextureProcessorData> manData) {
        this.manipulationType = (ManipulationType)((Object)manData.getFirst());
        this.data = (TextureProcessorData)manData.getSecond();
    }

    public ManipulationType getManipulationType() {
        return this.manipulationType;
    }

    public TextureProcessorData getData() {
        return this.data;
    }

    public static enum ManipulationType {
        overlay(TextureProcessors::overlay),
        mask(TextureProcessors::mask),
        rotate(TextureProcessors::rotate),
        flip(TextureProcessors::flip);

        private static Codec<ManipulationType> CODEC;
        private BiFunction<TextureData, TextureProcessorData, TextureData> processor;

        private ManipulationType(BiFunction<TextureData, TextureProcessorData, TextureData> processor) {
            this.processor = processor;
        }

        public BiFunction<TextureData, TextureProcessorData, TextureData> getProcessor() {
            return this.processor;
        }

        static {
            CODEC = Codec.STRING.comapFlatMap(new EnumDecoder<ManipulationType>(ManipulationType.class)::decode, Enum::toString).stable();
        }
    }
}

