/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.marg.common.generators.text.generator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.dark_roleplay.marg.common.generators.text.util.TextUtils;
import net.dark_roleplay.marg.common.material.MargMaterial;
import net.dark_roleplay.marg.common.providers.TextProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.fml.LogicalSide;

public class TextGeneratorTask {
    private static Pattern regexPattern = Pattern.compile("\\$\\{custom\\}");
    public static final Codec<TextGeneratorTask> CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.f_135803_.fieldOf("input").forGetter(TextGeneratorTask::getInput), (App)Codec.STRING.fieldOf("output").forGetter(TextGeneratorTask::getOutput)).apply((Applicative)i, TextGeneratorTask::new));
    private final ResourceLocation input;
    private final String output;
    private LogicalSide side;

    public TextGeneratorTask(ResourceLocation input, String output) {
        this.input = input;
        this.output = output;
    }

    public void setLogicalSide(LogicalSide side) {
        this.side = side;
    }

    public void generate(ResourceManager manager, Set<MargMaterial> materials, List<String> customs) {
        block6: {
            Matcher nameMatcher;
            String content;
            block5: {
                content = TextUtils.loadTextFile(this.input, manager);
                if (content == null) {
                    return;
                }
                nameMatcher = regexPattern.matcher(this.output);
                if (materials != null && !materials.isEmpty() || customs == null) break block5;
                Matcher contentMatcher = regexPattern.matcher(content);
                for (String custom : customs) {
                    TextUtils.writeTextFile(new ResourceLocation(nameMatcher.replaceAll(custom)), this.side, contentMatcher.replaceAll(custom));
                }
                break block6;
            }
            if (materials == null) break block6;
            boolean isCombined = nameMatcher.find();
            for (MargMaterial material : materials) {
                TextProvider prov = material.getTextProvider();
                String materialOutputLoc = prov.apply(this.output);
                String materialContent = prov.apply(content);
                if (isCombined) {
                    Matcher materialContentMatcher = regexPattern.matcher(materialContent);
                    nameMatcher = regexPattern.matcher(materialOutputLoc);
                    for (String custom : customs) {
                        TextUtils.writeTextFile(new ResourceLocation(nameMatcher.replaceAll(custom)), this.side, materialContentMatcher.replaceAll(custom));
                    }
                    continue;
                }
                TextUtils.writeTextFile(new ResourceLocation(materialOutputLoc), this.side, materialContent);
            }
        }
    }

    public ResourceLocation getInput() {
        return this.input;
    }

    public String getOutput() {
        return this.output;
    }
}

