/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.feature.EnumMode;
import doggytalents.common.entity.DogEntity;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.phys.Vec3;

public class DogWanderGoal
extends Goal {
    protected final DogEntity dog;
    protected final double speed;
    protected int executionChance;

    public DogWanderGoal(DogEntity dogIn, double speedIn) {
        this.dog = dogIn;
        this.speed = speedIn;
        this.executionChance = 60;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (!this.dog.m_21824_() || this.dog.m_20160_()) {
            return false;
        }
        if (!this.dog.isMode(EnumMode.WANDERING)) {
            return false;
        }
        Optional<BlockPos> bowlPos = this.dog.getBowlPos();
        if (!bowlPos.isPresent()) {
            return false;
        }
        return bowlPos.get().m_123331_((Vec3i)this.dog.m_142538_()) < 400.0;
    }

    public void m_8037_() {
        if (this.dog.m_21216_() >= 100) {
            return;
        }
        if (this.dog.m_21187_().nextInt(this.executionChance) != 0) {
            return;
        }
        if (this.dog.m_21691_()) {
            return;
        }
        Vec3 pos = this.getPosition();
        this.dog.m_21573_().m_26519_(pos.f_82479_, pos.f_82480_, pos.f_82481_, this.speed);
    }

    @Nullable
    protected Vec3 getPosition() {
        PathNavigation pathNavigate = this.dog.m_21573_();
        Random random = this.dog.m_21187_();
        int xzRange = 5;
        int yRange = 3;
        float bestWeight = Float.MIN_VALUE;
        Optional<BlockPos> bowlPos = this.dog.getBowlPos();
        BlockPos bestPos = bowlPos.get();
        for (int attempt = 0; attempt < 5; ++attempt) {
            float weight;
            int l = random.nextInt(2 * xzRange + 1) - xzRange;
            int i1 = random.nextInt(2 * yRange + 1) - yRange;
            int j1 = random.nextInt(2 * xzRange + 1) - xzRange;
            BlockPos testPos = bowlPos.get().m_142082_(l, i1, j1);
            if (!pathNavigate.m_6342_(testPos) || !((weight = this.dog.m_21692_(testPos)) > bestWeight)) continue;
            bestWeight = weight;
            bestPos = testPos;
        }
        return new Vec3((double)bestPos.m_123341_(), (double)bestPos.m_123342_(), (double)bestPos.m_123343_());
    }
}

