/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api;

import io.github.lightman314.lightmanscurrency.api.TextLogger;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.tradedata.PaygateTradeData;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class PaygateLogger
extends TextLogger {
    public PaygateLogger() {
        super("PaygateHistory");
    }

    public void AddLog(PlayerReference player, PaygateTradeData trade, @Nonnull CoinValue pricePaid, boolean isCreative) {
        Component creativeText = PaygateLogger.getCreativeText(isCreative);
        Component playerName = PaygateLogger.getPlayerText(player);
        MutableComponent durationText = PaygateTradeData.formatDurationShort(trade.getDuration());
        if (trade.isTicketTrade()) {
            this.AddLog((MutableComponent)new TranslatableComponent("log.shoplog.paygate.format.ticket", new Object[]{creativeText, playerName, trade.getTicketID().toString(), durationText}));
        } else {
            this.AddLog((MutableComponent)new TranslatableComponent("log.shoplog.paygate.format.coin", new Object[]{creativeText, playerName, PaygateLogger.getCostText(pricePaid), durationText}));
        }
    }
}

