/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen;

import com.google.common.base.Supplier;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.screen.ITradeRuleScreenHandler;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.IconButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TradeRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class TradeRuleScreen
extends Screen {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/traderules.png");
    private static final List<Supplier<TradeRule>> REGISTERED_RULES = new ArrayList<Supplier<TradeRule>>();
    public final int xSize = 176;
    public final int ySize = 176;
    final ITradeRuleScreenHandler handler;
    int openTab = -1;
    Button managerTab;
    List<Button> tabButtons = new ArrayList<Button>();
    List<Button> removeRuleButtons = new ArrayList<Button>();
    List<Button> addRuleButtons = new ArrayList<Button>();
    TradeRule.GUIHandler currentGUIHandler = null;

    public static void RegisterTradeRule(Supplier<TradeRule> rule) {
        REGISTERED_RULES.forEach(registeredRule -> {
            if (((TradeRule)registeredRule.get()).type == ((TradeRule)rule.get()).type) {
                return;
            }
        });
        REGISTERED_RULES.add(rule);
    }

    public final int guiLeft() {
        Objects.requireNonNull(this);
        return (this.f_96543_ - 176) / 2;
    }

    public final int guiTop() {
        Objects.requireNonNull(this);
        return (this.f_96544_ - 176) / 2;
    }

    List<TradeRule> activeRules() {
        return this.handler.ruleHandler().getRules();
    }

    TradeRule currentRule() {
        if (this.openTab >= 0 && this.openTab < this.activeRules().size()) {
            return this.activeRules().get(this.openTab);
        }
        return null;
    }

    List<TradeRule> addableRules() {
        ArrayList<TradeRule> addableRules = new ArrayList<TradeRule>();
        REGISTERED_RULES.forEach(rule -> addableRules.add((TradeRule)rule.get()));
        this.activeRules().forEach(rule -> {
            for (int i = 0; i < addableRules.size(); ++i) {
                if (((TradeRule)addableRules.get((int)i)).type != rule.type) continue;
                addableRules.remove(i);
            }
        });
        return addableRules;
    }

    public TradeRuleScreen(ITradeRuleScreenHandler handler) {
        super((Component)new TextComponent(""));
        this.handler = handler;
    }

    public void m_7856_() {
        int n = this.guiLeft();
        Objects.requireNonNull(this);
        this.m_142416_((GuiEventListener)new IconButton(n + 176, this.guiTop(), this::PressBackButton, IconAndButtonUtil.ICON_BACK));
        this.managerTab = (Button)this.m_142416_((GuiEventListener)new IconButton(this.guiLeft(), this.guiTop() - 20, this::PressTabButton, IconAndButtonUtil.ICON_TRADE_RULES));
        this.refreshTabs();
        this.initManagerTab();
    }

    private void initManagerTab() {
        int i;
        int y = 0;
        this.removeRuleButtons.clear();
        for (i = 0; i < this.activeRules().size(); ++i) {
            this.removeRuleButtons.add((Button)this.m_142416_((GuiEventListener)new IconButton(this.guiLeft() + 10, this.guiTop() + 10 + 20 * y, this::PressRemoveRuleButton, IconAndButtonUtil.ICON_X)));
            ++y;
        }
        this.addRuleButtons.clear();
        for (i = 0; i < this.addableRules().size(); ++i) {
            this.addRuleButtons.add((Button)this.m_142416_((GuiEventListener)new IconButton(this.guiLeft() + 10, this.guiTop() + 10 + 20 * y, this::PressAddRuleButton, IconAndButtonUtil.ICON_PLUS)));
            ++y;
        }
    }

    private void closeManagerTab() {
        this.addRuleButtons.forEach(button -> this.m_169411_((GuiEventListener)button));
        this.addRuleButtons.clear();
        this.removeRuleButtons.forEach(button -> this.m_169411_((GuiEventListener)button));
        this.removeRuleButtons.clear();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        int i;
        this.m_7333_(poseStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int n = this.guiLeft();
        int n2 = this.guiTop();
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        this.m_93228_(poseStack, n, n2, 0, 0, 176, 176);
        if (this.currentGUIHandler != null) {
            this.currentGUIHandler.renderTab(poseStack, mouseX, mouseY, partialTicks);
        } else {
            if (this.openTab >= 0) {
                this.openTab = -1;
            }
            int y = 0;
            for (i = 0; i < this.activeRules().size(); ++i) {
                this.f_96547_.m_92883_(poseStack, this.activeRules().get(i).getName().getString(), (float)(this.guiLeft() + 34), (float)(this.guiTop() + 16 + y * 20), 0xFFFFFF);
                ++y;
            }
            for (i = 0; i < this.addableRules().size(); ++i) {
                this.f_96547_.m_92883_(poseStack, this.addableRules().get(i).getName().getString(), (float)(this.guiLeft() + 34), (float)(this.guiTop() + 16 + y * 20), 0xFFFFFF);
                ++y;
            }
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        if (this.managerTab.m_5953_((double)mouseX, (double)mouseY)) {
            this.m_96602_(poseStack, (Component)new TranslatableComponent("gui.button.lightmanscurrency.mananger"), mouseX, mouseY);
        } else {
            boolean hoverButton = true;
            for (i = 0; i < this.tabButtons.size() && i < this.activeRules().size() && hoverButton; ++i) {
                Button thisTab = this.tabButtons.get(i);
                if (!thisTab.m_5953_((double)mouseX, (double)mouseY)) continue;
                this.m_96602_(poseStack, this.activeRules().get(i).getName(), mouseX, mouseY);
                hoverButton = false;
            }
            for (i = 0; i < this.removeRuleButtons.size() && i < this.activeRules().size() && hoverButton; ++i) {
                if (!this.removeRuleButtons.get(i).m_5953_((double)mouseX, (double)mouseY)) continue;
                this.m_96602_(poseStack, (Component)new TranslatableComponent("gui.button.lightmanscurrency.removerule", new Object[]{this.activeRules().get(i).getName()}), mouseX, mouseY);
                hoverButton = false;
            }
            for (i = 0; i < this.addRuleButtons.size() && i < this.addableRules().size() && hoverButton; ++i) {
                if (!this.addRuleButtons.get(i).m_5953_((double)mouseX, (double)mouseY)) continue;
                this.m_96602_(poseStack, (Component)new TranslatableComponent("gui.button.lightmanscurrency.addrule", new Object[]{this.addableRules().get(i).getName()}), mouseX, mouseY);
                hoverButton = false;
            }
        }
    }

    public void m_96624_() {
        if (!this.handler.stillValid()) {
            this.f_96541_.m_91152_(null);
            return;
        }
        if (this.currentGUIHandler != null) {
            this.currentGUIHandler.onScreenTick();
        }
    }

    void PressBackButton(Button button) {
        this.handler.reopenLastScreen();
    }

    void PressTabButton(Button button) {
        if (this.tabButtons.contains(button)) {
            if (this.openTab == this.tabButtons.indexOf(button)) {
                return;
            }
            if (this.currentGUIHandler != null) {
                this.currentGUIHandler.onTabClose();
                this.currentGUIHandler = null;
            } else {
                this.closeManagerTab();
            }
            this.openTab = this.tabButtons.indexOf(button);
            if (this.currentRule() != null) {
                this.currentGUIHandler = this.currentRule().createHandler(this, (Supplier<TradeRule>)((Supplier)() -> this.currentRule()));
                this.currentGUIHandler.initTab();
            }
        } else if (button == this.managerTab) {
            if (this.openTab < 0) {
                return;
            }
            if (this.currentGUIHandler != null) {
                this.currentGUIHandler.onTabClose();
                this.currentGUIHandler = null;
            }
            this.openTab = -1;
            this.initManagerTab();
        }
    }

    void PressAddRuleButton(Button button) {
        int addIndex;
        if (this.addRuleButtons.contains(button) && (addIndex = this.addRuleButtons.indexOf(button)) >= 0 && addIndex < this.addableRules().size()) {
            TradeRule newRule = this.addableRules().get(addIndex);
            this.handler.ruleHandler().getRules().add(newRule);
            this.handler.updateServer(newRule.type, TradeRule.CreateRuleMessage());
            LightmansCurrency.LogInfo("Adding rule type " + newRule.getName().getString());
            this.closeManagerTab();
            this.refreshTabs();
            this.initManagerTab();
        }
    }

    void PressRemoveRuleButton(Button button) {
        int removeIndex;
        if (this.removeRuleButtons.contains(button) && (removeIndex = this.removeRuleButtons.indexOf(button)) >= 0 && removeIndex < this.activeRules().size()) {
            TradeRule removedRule = this.activeRules().get(removeIndex);
            this.handler.ruleHandler().getRules().remove(removeIndex);
            this.handler.updateServer(removedRule.type, TradeRule.RemoveRuleMessage());
            LightmansCurrency.LogInfo("Removing rule type " + removedRule.getName().getString());
            this.closeManagerTab();
            this.refreshTabs();
            this.initManagerTab();
        }
    }

    public void updateServer(ResourceLocation type, CompoundTag updateInfo) {
        this.handler.updateServer(type, updateInfo);
    }

    public void refreshTabs() {
        this.tabButtons.forEach(button -> this.m_169411_((GuiEventListener)button));
        this.tabButtons.clear();
        List<TradeRule> activeRules = this.activeRules();
        for (int i = 0; i < activeRules.size(); ++i) {
            TradeRule thisRule = activeRules.get(i);
            this.tabButtons.add((Button)this.m_142416_((GuiEventListener)new IconButton(this.guiLeft() + 20 + 20 * i, this.guiTop() - 20, this::PressTabButton, thisRule.getButtonIcon())));
        }
    }

    public Font getFont() {
        return this.f_96547_;
    }

    public <T extends GuiEventListener & Widget> T addCustomRenderable(T widget) {
        if (widget != null) {
            this.m_142416_(widget);
        }
        return widget;
    }

    public <T extends GuiEventListener & NarratableEntry> T addCustomWidget(T widget) {
        if (widget != null) {
            this.m_7787_(widget);
        }
        return widget;
    }

    public <T extends GuiEventListener> void removeCustomWidget(T widget) {
        this.m_169411_(widget);
    }
}

