/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.settings.SettingsTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.TabButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.settings.Settings;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class TraderSettingsScreen
extends Screen {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/tradersettings.png");
    private final Supplier<ITrader> trader;
    private final Consumer<Player> openStorage;
    public final int xSize = 200;
    public final int ySize = 200;
    List<Settings> settings;
    List<AbstractWidget> tabWidgets = Lists.newArrayList();
    List<GuiEventListener> tabListeners = Lists.newArrayList();
    List<TabButton> tabButtons = Lists.newArrayList();
    List<SettingsTab> tabs;
    int currentTabIndex = 0;

    public Player getPlayer() {
        return this.f_96541_.f_91074_;
    }

    public ITrader getTrader() {
        return (ITrader)this.trader.get();
    }

    public Font getFont() {
        return this.f_96547_;
    }

    public final int guiLeft() {
        Objects.requireNonNull(this);
        return (this.f_96543_ - 200) / 2;
    }

    public final int guiTop() {
        Objects.requireNonNull(this);
        return (this.f_96544_ - 200) / 2;
    }

    public List<Settings> getSettings() {
        return this.settings;
    }

    public SettingsTab currentTab() {
        return this.tabs.get(MathUtil.clamp(this.currentTabIndex, 0, this.tabs.size() - 1));
    }

    public <T extends Settings> T getSetting(Class<T> type) {
        for (int i = 0; i < this.settings.size(); ++i) {
            if (this.settings.get(i).getClass() != type) continue;
            return (T)this.settings.get(i);
        }
        return null;
    }

    public TraderSettingsScreen(Supplier<ITrader> trader, Consumer<Player> openStorage) {
        super((Component)new TextComponent(""));
        this.trader = trader;
        this.openStorage = openStorage;
        this.settings = Lists.newArrayList((Object[])new Settings[]{this.getTrader().getCoreSettings()});
        this.settings.addAll(this.getTrader().getAdditionalSettings());
        this.tabs = Lists.newArrayList();
        this.settings.forEach(setting -> this.tabs.addAll(setting.getSettingsTabs()));
        this.settings.forEach(setting -> this.tabs.addAll(setting.getBackEndSettingsTabs()));
        this.tabs.forEach(tab -> tab.setScreen(this));
    }

    public void m_7856_() {
        this.m_142416_((GuiEventListener)new IconButton(this.guiLeft(), this.guiTop() - 20, this::OpenStorage, IconAndButtonUtil.ICON_BACK));
        for (int i = 0; i < this.tabs.size(); ++i) {
            TabButton button = (TabButton)this.m_142416_((GuiEventListener)new TabButton(this::clickedOnTab, this.f_96547_, this.tabs.get(i)));
            button.f_93623_ = i != this.currentTabIndex;
            button.f_93624_ = this.tabs.get(i).canOpen();
            this.tabButtons.add(button);
        }
        this.positionTabButtons();
        this.currentTab().initTab();
    }

    private int getTabPosX(int index) {
        if (index < 7) {
            return this.guiLeft() + 20 + 25 * index;
        }
        if (index < 15) {
            int n = this.guiLeft();
            Objects.requireNonNull(this);
            return n + 200;
        }
        if (index < 23) {
            int n = this.guiLeft();
            Objects.requireNonNull(this);
            return n + 200 - 25 * (index - 15);
        }
        return this.guiLeft() - 25;
    }

    private int getTabPosY(int index) {
        if (index < 7) {
            return this.guiTop() - 25;
        }
        if (index < 15) {
            return this.guiTop() + 25 * (index - 10);
        }
        if (index < 23) {
            int n = this.guiTop();
            Objects.requireNonNull(this);
            return n + 200;
        }
        int n = this.guiTop();
        Objects.requireNonNull(this);
        return n + 200 - 25 * (index - 23);
    }

    private int getTabRotation(int index) {
        if (index < 7) {
            return 0;
        }
        if (index < 15) {
            return 1;
        }
        if (index < 23) {
            return 2;
        }
        return 3;
    }

    private void positionTabButtons() {
        int index = 0;
        for (int i = 0; i < this.tabButtons.size(); ++i) {
            TabButton thisButton = this.tabButtons.get(i);
            if (!thisButton.f_93624_) continue;
            thisButton.reposition(this.getTabPosX(index), this.getTabPosY(index), this.getTabRotation(index));
            ++index;
        }
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrix);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        this.setColor(this.currentTab().getColor());
        int n = this.guiLeft();
        int n2 = this.guiTop();
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        this.m_93228_(matrix, n, n2, 0, 0, 200, 200);
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
        this.currentTab().preRender(matrix, mouseX, mouseY, partialTicks);
        this.tabWidgets.forEach(widget -> widget.m_6305_(matrix, mouseX, mouseY, partialTicks));
        this.currentTab().postRender(matrix, mouseX, mouseY, partialTicks);
        for (int i = 0; i < this.tabButtons.size(); ++i) {
            if (!this.tabButtons.get(i).m_5953_(mouseX, mouseY)) continue;
            this.m_96602_(matrix, this.tabButtons.get((int)i).tab.getTooltip(), mouseX, mouseY);
        }
    }

    public void setColor(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)1.0f);
    }

    public void m_96624_() {
        if (this.getTrader() == null) {
            this.f_96541_.m_91152_(null);
            return;
        }
        if (!this.hasPermission("editSettings")) {
            this.f_96541_.m_91152_(null);
            if (this.hasPermission("openStorage")) {
                this.openStorage.accept(this.getPlayer());
            }
            return;
        }
        boolean updateTabs = false;
        for (int i = 0; i < this.tabs.size(); ++i) {
            boolean visible = this.tabs.get(i).canOpen();
            if (visible == this.tabButtons.get((int)i).f_93624_) continue;
            updateTabs = true;
            this.tabButtons.get((int)i).f_93624_ = visible;
        }
        if (updateTabs) {
            this.positionTabButtons();
        }
        if (!this.currentTab().canOpen()) {
            this.clickedOnTab(this.tabButtons.get(0));
        }
        this.currentTab().tick();
    }

    public boolean hasPermission(String permission) {
        if (this.trader.get() != null) {
            return ((ITrader)this.trader.get()).getCoreSettings().hasPermission(this.getPlayer(), permission);
        }
        return false;
    }

    public int getPermissionLevel(String permission) {
        if (this.trader.get() != null) {
            return ((ITrader)this.trader.get()).getCoreSettings().getPermissionLevel(this.getPlayer(), permission);
        }
        return 0;
    }

    public boolean hasPermissions(List<String> permissions) {
        for (int i = 0; i < permissions.size(); ++i) {
            if (this.hasPermission(permissions.get(i))) continue;
            return false;
        }
        return true;
    }

    public <T extends AbstractWidget> T addRenderableTabWidget(T widget) {
        this.tabWidgets.add(widget);
        return widget;
    }

    public void removeRenderableTabWidget(AbstractWidget widget) {
        if (this.tabWidgets.contains(widget)) {
            this.tabWidgets.remove(widget);
        }
    }

    public <T extends GuiEventListener> T addTabListener(T listener) {
        this.tabListeners.add(listener);
        return listener;
    }

    public void removeTabListener(GuiEventListener listener) {
        if (this.tabListeners.contains(listener)) {
            this.tabListeners.remove(listener);
        }
    }

    private void clickedOnTab(Button tab) {
        int tabIndex = this.tabButtons.indexOf(tab);
        if (tabIndex < 0) {
            return;
        }
        if (tabIndex != this.currentTabIndex) {
            this.currentTab().closeTab();
            this.tabButtons.get((int)this.currentTabIndex).f_93623_ = true;
            this.currentTabIndex = tabIndex;
            this.tabButtons.get((int)this.currentTabIndex).f_93623_ = false;
            this.tabWidgets.clear();
            this.tabListeners.clear();
            this.currentTab().initTab();
        }
    }

    private void OpenStorage(Button button) {
        this.openStorage.accept(this.getPlayer());
    }

    public List<? extends GuiEventListener> m_6702_() {
        List coreListeners = super.m_6702_();
        ArrayList listeners = Lists.newArrayList();
        for (int i = 0; i < coreListeners.size(); ++i) {
            listeners.add((GuiEventListener)coreListeners.get(i));
        }
        listeners.addAll(this.tabWidgets);
        listeners.addAll(this.tabListeners);
        return listeners;
    }

    public boolean m_7043_() {
        return false;
    }
}

