/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.trader.auction;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.trader.TraderClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.CoinValueInput;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.common.universal_traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.auction.MessageSubmitBid;
import io.github.lightman314.lightmanscurrency.trader.tradedata.AuctionTradeData;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class AuctionBidTab
extends TraderClientTab {
    private final UUID auctionHouseID;
    private final int tradeIndex;
    TradeButton tradeDisplay;
    CoinValueInput bidAmount;
    Button bidButton;
    Button closeButton;

    private AuctionHouseTrader getAuctionHouse() {
        UniversalTraderData data = ClientTradingOffice.getData(this.auctionHouseID);
        if (data instanceof AuctionHouseTrader) {
            return (AuctionHouseTrader)data;
        }
        return null;
    }

    private AuctionTradeData getTrade() {
        AuctionHouseTrader trader = this.getAuctionHouse();
        if (trader != null) {
            return trader.getTrade(this.tradeIndex);
        }
        return null;
    }

    public AuctionBidTab(TraderScreen screen, UUID auctionHouseID, int tradeIndex) {
        super(screen);
        this.auctionHouseID = auctionHouseID;
        this.tradeIndex = tradeIndex;
    }

    @Override
    public boolean blockInventoryClosing() {
        return false;
    }

    @Override
    public void onOpen() {
        if (this.getTrade() == null) {
            return;
        }
        this.tradeDisplay = this.screen.addRenderableTabWidget(new TradeButton(() -> this.menu.getContext(this.getAuctionHouse()), this::getTrade, b -> {}));
        this.tradeDisplay.move(this.screen.getGuiLeft() + this.screen.getXSize() / 2 - this.tradeDisplay.m_5711_() / 2, this.screen.getGuiTop() + 5);
        this.bidAmount = this.screen.addRenderableTabWidget(new CoinValueInput(this.screen.getGuiLeft() + this.screen.getXSize() / 2 - 88, this.screen.getGuiTop() + 10 + this.tradeDisplay.m_93694_(), (Component)new TranslatableComponent("gui.lightmanscurrency.auction.bidamount"), this.getTrade().getMinNextBid(), this.font, v -> {}, this.screen::addRenderableTabWidget));
        this.bidAmount.init();
        this.bidAmount.allowFreeToggle = false;
        this.bidAmount.drawBG = false;
        this.bidButton = this.screen.addRenderableTabWidget(new Button(this.screen.getGuiLeft() + 22, this.screen.getGuiTop() + 119, 68, 20, (Component)new TranslatableComponent("gui.lightmanscurrency.auction.bid"), this::SubmitBid));
        this.closeButton = this.screen.addRenderableTabWidget(new Button(this.screen.getGuiLeft() + this.screen.getXSize() - 25, this.screen.getGuiTop() + 5, 20, 20, (Component)new TextComponent("X").m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.BOLD), this::close));
        this.tick();
    }

    @Override
    public void renderBG(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void renderTooltips(PoseStack pose, int mouseX, int mouseY) {
        this.tradeDisplay.renderTooltips(pose, mouseX, mouseY);
    }

    @Override
    public void tick() {
        CoinValue minBid;
        if (this.getTrade() == null) {
            this.screen.closeTab();
            return;
        }
        long bidQuery = this.bidAmount.getCoinValue().getRawValue();
        if (bidQuery < (minBid = this.getTrade().getMinNextBid()).getRawValue()) {
            this.bidAmount.setCoinValue(this.getTrade().getMinNextBid());
        }
        this.bidButton.f_93623_ = this.menu.getContext(this.getAuctionHouse()).getAvailableFunds() >= bidQuery;
        this.bidAmount.tick();
    }

    private void SubmitBid(Button button) {
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageSubmitBid(this.auctionHouseID, this.tradeIndex, this.bidAmount.getCoinValue()));
        this.screen.closeTab();
    }

    private void close(Button button) {
        this.screen.closeTab();
    }
}

