/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.item;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.CoinValueInput;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ItemEditWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TradeButtonArea;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.menus.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.menus.traderstorage.item.ItemTradeEditTab;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ItemTradeEditClientTab
extends TraderStorageClientTab<ItemTradeEditTab>
implements TradeButtonArea.InteractionConsumer,
ItemEditWidget.IItemEditListener {
    private static final int X_OFFSET = 13;
    private static final int Y_OFFSET = 71;
    private static final int COLUMNS = 10;
    private static final int ROWS = 2;
    TradeButton tradeDisplay;
    CoinValueInput priceSelection;
    EditBox customNameInput;
    ItemEditWidget itemEdit;
    ScrollBarWidget itemEditScroll;
    Button buttonToggleTradeType;
    private int selection = -1;
    private int itemEditScrollValue = -1;

    public ItemTradeEditClientTab(TraderStorageScreen screen, ItemTradeEditTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    public IconData getIcon() {
        return IconData.BLANK;
    }

    @Override
    public Component getTooltip() {
        return new TextComponent("");
    }

    @Override
    public boolean tabButtonVisible() {
        return false;
    }

    @Override
    public boolean blockInventoryClosing() {
        return true;
    }

    @Override
    public int getTradeRuleTradeIndex() {
        return ((ItemTradeEditTab)this.commonTab).getTradeIndex();
    }

    @Override
    public void onOpen() {
        ItemTradeData trade = this.getTrade();
        this.tradeDisplay = this.screen.addRenderableTabWidget(new TradeButton(this.menu::getContext, ((ItemTradeEditTab)this.commonTab)::getTrade, button -> {}));
        this.tradeDisplay.move(this.screen.getGuiLeft() + 10, this.screen.getGuiTop() + 18);
        this.priceSelection = this.screen.addRenderableTabWidget(new CoinValueInput(this.screen.getGuiLeft() + 103 - 88, this.screen.getGuiTop() + 40, (Component)new TextComponent(""), trade == null ? CoinValue.EMPTY : trade.getCost(), this.font, this::onValueChanged, this.screen::addRenderableTabWidget));
        this.priceSelection.drawBG = false;
        this.priceSelection.init();
        this.itemEdit = this.screen.addRenderableTabWidget(new ItemEditWidget(this.screen.getGuiLeft() + 13, this.screen.getGuiTop() + 71, 10, 2, this));
        this.itemEdit.init(this.screen::addRenderableTabWidget, this.screen::addTabListener);
        if (this.itemEditScrollValue >= 0) {
            this.itemEdit.setScroll(this.itemEditScrollValue);
        }
        this.itemEditScroll = this.screen.addRenderableTabWidget(new ScrollBarWidget(this.screen.getGuiLeft() + 13 + 180, this.screen.getGuiTop() + 71, 36, this.itemEdit));
        this.itemEditScroll.smallKnob = true;
        int labelWidth = this.font.m_92852_((FormattedText)new TranslatableComponent("gui.lightmanscurrency.customname"));
        this.customNameInput = this.screen.addRenderableTabWidget(new EditBox(this.font, this.screen.getGuiLeft() + 15 + labelWidth, this.screen.getGuiTop() + 38, this.screen.getXSize() - 28 - labelWidth, 18, (Component)new TextComponent("")));
        if (this.selection >= 0 && this.selection < 2 && trade != null) {
            this.customNameInput.m_94144_(trade.getCustomName(this.selection));
        }
        this.buttonToggleTradeType = this.screen.addRenderableTabWidget(new Button(this.screen.getGuiLeft() + 113, this.screen.getGuiTop() + 15, 80, 20, (Component)new TextComponent(""), this::ToggleTradeType));
    }

    @Override
    public void onClose() {
        this.selection = -1;
        this.itemEditScrollValue = -1;
    }

    @Override
    public void renderBG(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        if (this.getTrade() == null) {
            return;
        }
        this.validateRenderables();
        if (this.itemEditScroll.f_93624_) {
            this.itemEditScroll.beforeWidgetRender(mouseY);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)TraderScreen.GUI_TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.screen.m_93228_(pose, this.getArrowPosition(), this.screen.getGuiTop() + 10, 214, 18, 8, 6);
        if (this.customNameInput.f_93624_) {
            this.font.m_92889_(pose, (Component)new TranslatableComponent("gui.lightmanscurrency.customname"), (float)(this.screen.getGuiLeft() + 13), (float)(this.screen.getGuiTop() + 42), 0x404040);
        }
    }

    private int getArrowPosition() {
        ItemTradeData trade = this.getTrade();
        if (this.selection == -1) {
            if (trade.isSale()) {
                return this.screen.getGuiLeft() + 25;
            }
            if (trade.isPurchase()) {
                return this.screen.getGuiLeft() + 81;
            }
            return -100;
        }
        if (this.selection >= 2 && !trade.isBarter()) {
            return -100;
        }
        int horizSlot = this.selection;
        if (trade.isSale() || trade.isBarter()) {
            horizSlot += 2;
        }
        int spacing = horizSlot % 4 >= 2 ? 20 : 0;
        return this.screen.getGuiLeft() + 16 + 18 * (horizSlot % 4) + spacing;
    }

    private void validateRenderables() {
        boolean bl = this.priceSelection.f_93624_ = this.selection < 0 && !this.getTrade().isBarter();
        if (this.priceSelection.f_93624_) {
            this.priceSelection.tick();
        }
        this.itemEdit.f_93624_ = this.selection >= 0 && (this.getTrade().isBarter() ? this.selection < 4 : this.selection < 2);
        this.itemEditScroll.f_93624_ = this.itemEdit.f_93624_;
        boolean bl2 = this.customNameInput.f_93624_ = this.selection >= 0 && this.selection < 2 && !this.getTrade().isPurchase();
        if (this.customNameInput.f_93624_ && !this.customNameInput.m_94155_().contentEquals(this.getTrade().getCustomName(this.selection))) {
            ((ItemTradeEditTab)this.commonTab).setCustomName(this.selection, this.customNameInput.m_94155_());
        }
        this.buttonToggleTradeType.m_93666_((Component)new TranslatableComponent("gui.button.lightmanscurrency.tradedirection." + this.getTrade().getTradeType().name().toLowerCase()));
    }

    @Override
    public void tick() {
        if (this.customNameInput.f_93624_) {
            this.customNameInput.m_94120_();
        }
        if (this.itemEdit.f_93624_) {
            this.itemEdit.tick();
            this.itemEditScrollValue = this.itemEdit.currentScroll();
        }
    }

    @Override
    public void renderTooltips(PoseStack pose, int mouseX, int mouseY) {
        this.tradeDisplay.renderTooltips(pose, mouseX, mouseY);
        if (this.selection >= 0) {
            this.itemEdit.renderTooltips((Screen)this.screen, pose, mouseX, mouseY);
        }
    }

    @Override
    public void receiveSelfMessage(CompoundTag message) {
        if (message.m_128441_("TradeIndex")) {
            ((ItemTradeEditTab)this.commonTab).setTradeIndex(message.m_128451_("TradeIndex"));
        }
        if (message.m_128441_("StartingSlot")) {
            this.selection = message.m_128451_("StartingSlot");
        }
    }

    @Override
    public void onTradeButtonInputInteraction(ITrader trader, TradeButton.ITradeData trade, int index, int mouseButton) {
        if (trade instanceof ItemTradeData) {
            ItemTradeData t = (ItemTradeData)trade;
            if (t.isSale()) {
                this.changeSelection(-1);
            } else if (t.isPurchase()) {
                this.changeSelection(index);
            } else if (t.isBarter()) {
                this.changeSelection(index + 2);
            }
        }
    }

    @Override
    public void onTradeButtonOutputInteraction(ITrader trader, TradeButton.ITradeData trade, int index, int mouseButton) {
        if (trade instanceof ItemTradeData) {
            ItemTradeData t = (ItemTradeData)trade;
            if (t.isSale() || t.isBarter()) {
                this.changeSelection(index);
            } else if (t.isPurchase()) {
                this.changeSelection(-1);
            }
        }
    }

    private void changeSelection(int newSelection) {
        this.selection = newSelection;
        if (this.selection == -1) {
            this.priceSelection.setCoinValue(this.getTrade().getCost());
        }
        if (this.selection >= 0 && this.selection < 2) {
            this.customNameInput.m_94144_(((ItemTradeEditTab)this.commonTab).getTrade().getCustomName(this.selection));
        }
        if (this.selection >= 0) {
            this.itemEdit.refreshSearch();
        }
    }

    @Override
    public void onTradeButtonInteraction(ITrader trader, TradeButton.ITradeData trade, int localMouseX, int localMouseY, int mouseButton) {
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.tradeDisplay.onInteractionClick((int)mouseX, (int)mouseY, button, this);
        this.itemEditScroll.onMouseClicked(mouseX, mouseY, button);
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.itemEditScroll.onMouseReleased(mouseX, mouseY, button);
        return false;
    }

    public void onValueChanged(CoinValue value) {
        ((ItemTradeEditTab)this.commonTab).setPrice(value.copy());
    }

    @Override
    public ItemTradeData getTrade() {
        return ((ItemTradeEditTab)this.commonTab).getTrade();
    }

    @Override
    public boolean restrictItemEditItems() {
        return this.selection < 2;
    }

    @Override
    public void onItemClicked(ItemStack item) {
        ((ItemTradeEditTab)this.commonTab).setSelectedItem(this.selection, item);
    }

    private void ToggleTradeType(Button button) {
        if (this.getTrade() != null) {
            ((ItemTradeEditTab)this.commonTab).setType(this.getTrade().getTradeType().next());
        }
    }
}

