/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.team;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TeamManagerScreen;
import io.github.lightman314.lightmanscurrency.client.gui.team.TeamTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.teams.MessageDisbandTeam;
import io.github.lightman314.lightmanscurrency.network.message.teams.MessageEditTeam;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class TeamOwnerTab
extends TeamTab {
    public static final TeamOwnerTab INSTANCE = new TeamOwnerTab();
    EditBox newOwnerName;
    Button buttonChangeOwner;
    Button buttonDisbandTeam;

    private TeamOwnerTab() {
    }

    @Override
    public IconData getIcon() {
        return IconData.of((ItemLike)Items.f_42614_);
    }

    @Override
    public Component getTooltip() {
        return new TranslatableComponent("tooltip.lightmanscurrency.team.owner");
    }

    @Override
    public boolean allowViewing(Player player, Team team) {
        return team != null && team.isOwner(player);
    }

    @Override
    public void initTab() {
        if (this.getActiveTeam() == null) {
            this.getScreen().changeTab(0);
            return;
        }
        TeamManagerScreen screen = this.getScreen();
        this.newOwnerName = screen.addRenderableTabWidget(new EditBox(this.getFont(), screen.guiLeft() + 20, screen.guiTop() + 20, 160, 20, (Component)new TextComponent("")));
        this.newOwnerName.m_94199_(16);
        this.buttonChangeOwner = screen.addRenderableTabWidget(new Button(screen.guiLeft() + 20, screen.guiTop() + 45, 160, 20, (Component)new TranslatableComponent("gui.button.lightmanscurrency.set_owner"), this::setNewOwner));
        this.buttonChangeOwner.f_93623_ = false;
        this.buttonDisbandTeam = screen.addRenderableTabWidget(new Button(screen.guiLeft() + 20, screen.guiTop() + 160, 160, 20, (Component)new TranslatableComponent("gui.button.lightmanscurrency.team.disband"), this::disbandTeam));
    }

    @Override
    public void preRender(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        if (this.getActiveTeam() == null) {
            return;
        }
        TeamManagerScreen screen = this.getScreen();
        this.getFont().m_92889_(pose, (Component)new TranslatableComponent("gui.button.lightmanscurrency.team.owner", new Object[]{this.getActiveTeam().getOwner().lastKnownName()}), (float)(screen.guiLeft() + 20), (float)(screen.guiTop() + 10), 0x404040);
    }

    @Override
    public void postRender(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        if (this.buttonChangeOwner.m_5953_((double)mouseX, (double)mouseY) || this.buttonDisbandTeam.m_5953_((double)mouseX, (double)mouseY)) {
            this.getScreen().m_96602_(pose, (Component)new TranslatableComponent("tooltip.lightmanscurrency.warning").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW}), mouseX, mouseY);
        }
    }

    @Override
    public void tick() {
        this.newOwnerName.m_94120_();
        this.buttonChangeOwner.f_93623_ = !this.newOwnerName.m_94155_().isBlank();
    }

    @Override
    public void closeTab() {
    }

    private void setNewOwner(Button button) {
        if (this.newOwnerName.m_94155_().isBlank() || this.getActiveTeam() == null) {
            return;
        }
        Team team = this.getActiveTeam();
        team.changeOwner(this.getPlayer(), this.newOwnerName.m_94155_());
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageEditTeam(team.getID(), this.newOwnerName.m_94155_(), "OWNER"));
        this.newOwnerName.m_94144_("");
    }

    private void disbandTeam(Button button) {
        if (this.getActiveTeam() == null) {
            return;
        }
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageDisbandTeam(this.getActiveTeam().getID()));
    }
}

