/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class TimeWidget
extends AbstractWidget {
    public static final int WIDTH = 176;
    public static final int HEIGHT = 40;
    private EditBox hourInput;
    private EditBox minuteInput;
    private EditBox secondInput;
    Button setTimeButton;
    private TradeRule.GUIHandler handler;
    Font font;
    ITimeInput timeInput;
    Component noTimeText;
    long startingValue = 0L;

    public TimeWidget(int x, int y, Font font, long startingValue, TradeRule.GUIHandler handler, @Nullable ITimeInput timeInput, Component noTimeText) {
        super(x, y, 176, 40, (Component)new TextComponent(""));
        this.startingValue = startingValue;
        this.handler = handler;
        this.font = font;
        this.timeInput = timeInput;
        this.noTimeText = noTimeText;
        this.init();
    }

    protected void init() {
        TimeUtil.TimeData timeData = TimeUtil.separateDuration(this.startingValue);
        this.hourInput = this.handler.addCustomRenderable(new EditBox(this.font, this.f_93620_ + 10, this.f_93621_ + 19, 30, 20, (Component)new TextComponent("")));
        this.hourInput.m_94199_(3);
        this.hourInput.m_94144_(Long.toString(timeData.hours));
        this.minuteInput = this.handler.addCustomRenderable(new EditBox(this.font, this.f_93620_ + 80, this.f_93621_ + 19, 20, 20, (Component)new TextComponent("")));
        this.minuteInput.m_94199_(2);
        this.minuteInput.m_94144_(Long.toString(timeData.minutes));
        this.secondInput = this.handler.addCustomRenderable(new EditBox(this.font, this.f_93620_ + 130, this.f_93621_ + 19, 20, 20, (Component)new TextComponent("")));
        this.secondInput.m_94199_(2);
        this.secondInput.m_94144_(Long.toString(timeData.seconds));
        this.setTimeButton = this.handler.addCustomRenderable(new Button(this.f_93620_ + 80, this.f_93621_ - 2, 80, 20, (Component)new TranslatableComponent("gui.button.lightmanscurrency.time_widget.settime"), this::PressSetTimeButton));
        this.setTimeButton.f_93624_ = this.timeInput != null;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        TimeUtil.TimeData time = this.getTime();
        if (time.miliseconds > 0L) {
            this.font.m_92883_(poseStack, new TranslatableComponent("gui.widget.lightmanscurrency.time_widget.info", new Object[]{time.hours, time.minutes, time.seconds}).getString(), (float)(this.f_93620_ + 10), (float)(this.f_93621_ + 2), 0xFFFFFF);
        } else {
            this.font.m_92883_(poseStack, this.noTimeText.getString(), (float)(this.f_93620_ + 10), (float)(this.f_93621_ + 2), 0xFFFFFF);
        }
        this.font.m_92883_(poseStack, "h", (float)(this.f_93620_ + 62), (float)(this.f_93621_ + 25), 0xFFFFFF);
        this.font.m_92883_(poseStack, "m", (float)(this.f_93620_ + 112), (float)(this.f_93621_ + 25), 0xFFFFFF);
        this.font.m_92883_(poseStack, "s", (float)(this.f_93620_ + 162), (float)(this.f_93621_ + 25), 0xFFFFFF);
    }

    public List<AbstractWidget> getWidgets() {
        return ImmutableList.of((Object)this.setTimeButton, (Object)this.hourInput, (Object)this.minuteInput, (Object)this.secondInput);
    }

    public TimeUtil.TimeData getTime() {
        return new TimeUtil.TimeData(TimeWidget.inputValue(this.hourInput, false), TimeWidget.inputValue(this.minuteInput, true), TimeWidget.inputValue(this.secondInput, true));
    }

    private static long inputValue(EditBox textField, boolean clamp) {
        if (TimeWidget.isNumeric(textField.m_94155_())) {
            return MathUtil.clamp(Long.parseLong(textField.m_94155_()), 0L, 59L);
        }
        return 0L;
    }

    private static boolean isNumeric(String string) {
        if (string == null) {
            return false;
        }
        try {
            long l = Long.parseLong(string);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private void PressSetTimeButton(Button button) {
        if (this.timeInput != null) {
            this.timeInput.onTimeSet(this.getTime().miliseconds);
        }
    }

    public void m_142291_(NarrationElementOutput narration) {
    }

    public static interface ITimeInput {
        public void onTimeSet(long var1);
    }
}

