/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.atm.icons;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ATMScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.atm.ATMConversionButton;
import io.github.lightman314.lightmanscurrency.common.atm.ATMIconData;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SimpleArrowIcon
extends ATMIconData {
    public static final ResourceLocation TYPE_NAME = new ResourceLocation("lightmanscurrency", "small_arrow");
    public static final ATMIconData.IconType TYPE = ATMIconData.IconType.create(TYPE_NAME, SimpleArrowIcon::new);
    private final ArrowType direction;

    public SimpleArrowIcon(JsonObject data) {
        super(data);
        if (data.has("direction")) {
            this.direction = ArrowType.parse(data.get("direction").getAsString());
        } else {
            LightmansCurrency.LogWarning("Simple Arrow icon has no defined direction. Will assume it's pointing right.");
            this.direction = ArrowType.RIGHT;
        }
    }

    public SimpleArrowIcon(int xPos, int yPos, ArrowType direction) {
        super(xPos, yPos);
        this.direction = direction;
    }

    @Override
    protected void saveAdditional(JsonObject data) {
        data.addProperty("direction", this.direction.name());
    }

    @Override
    protected ResourceLocation getType() {
        return TYPE_NAME;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(ATMConversionButton button, PoseStack pose, boolean isHovered) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)ATMScreen.BUTTON_TEXTURE);
        button.m_93228_(pose, button.f_93620_ + this.xPos, button.f_93621_ + this.yPos, this.direction.uOffset, 36, 6, 6);
    }

    public static enum ArrowType {
        UP(0),
        DOWN(6),
        LEFT(12),
        RIGHT(18);

        public final int uOffset;

        private ArrowType(int uOffset) {
            this.uOffset = uOffset;
        }

        static ArrowType parse(String value) {
            for (ArrowType type : ArrowType.values()) {
                if (!type.name().equals(value)) continue;
                return type;
            }
            return RIGHT;
        }
    }
}

