/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.universal_traders.data;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.ItemShopLogger;
import io.github.lightman314.lightmanscurrency.blockentity.handler.TraderItemHandler;
import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.client.gui.screen.ITradeRuleScreenHandler;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.universal_trader.MessageAddOrRemoveTrade2;
import io.github.lightman314.lightmanscurrency.network.message.universal_trader.MessageOpenStorage2;
import io.github.lightman314.lightmanscurrency.network.message.universal_trader.MessageUpdateTradeRule2;
import io.github.lightman314.lightmanscurrency.trader.IItemTrader;
import io.github.lightman314.lightmanscurrency.trader.common.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.trader.settings.ItemTraderSettings;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.settings.Settings;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.ITradeRuleHandler;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;

public class UniversalItemTraderData
extends UniversalTraderData
implements IItemTrader {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "item_trader");
    public static final int VERSION = 1;
    TraderItemHandler itemHandler = new TraderItemHandler(this);
    private ItemTraderSettings itemSettings = new ItemTraderSettings(this, this::markItemSettingsDirty, this::sendSettingsUpdateToServer);
    int tradeCount = 1;
    List<ItemTradeData> trades = null;
    TraderItemStorage storage = new TraderItemStorage(this);
    Container upgradeInventory = new SimpleContainer(5);
    private final ItemShopLogger logger = new ItemShopLogger();
    List<TradeRule> tradeRules = new ArrayList<TradeRule>();

    @Override
    public IItemHandler getItemHandler(Direction relativeSide) {
        return this.itemHandler.getHandler(relativeSide);
    }

    @Override
    public Container getUpgradeInventory() {
        return this.upgradeInventory;
    }

    @Override
    public void markUpgradesDirty() {
        this.markDirty((Function<CompoundTag, CompoundTag>)((Function)this::writeUpgrades));
    }

    public UniversalItemTraderData() {
    }

    public UniversalItemTraderData(PlayerReference owner, BlockPos pos, ResourceKey<Level> world, UUID traderID, int tradeCount) {
        super(owner, pos, world, traderID);
        this.tradeCount = MathUtil.clamp(tradeCount, 1, 32);
        this.trades = ItemTradeData.listOfSize(this.tradeCount);
    }

    @Override
    protected ItemLike getCategoryItem() {
        int tradeCount;
        int n = tradeCount = this.isCreative() ? 32 : this.getTradeCount();
        if (tradeCount <= 3) {
            return ModBlocks.ITEM_TRADER_SERVER_SMALL;
        }
        if (tradeCount <= 6) {
            return ModBlocks.ITEM_TRADER_SERVER_MEDIUM;
        }
        if (tradeCount <= 12) {
            return ModBlocks.ITEM_TRADER_SERVER_LARGE;
        }
        return ModBlocks.ITEM_TRADER_SERVER_EXTRA_LARGE;
    }

    @Override
    public void read(CompoundTag compound) {
        if (compound.m_128425_("TradeLimit", 3)) {
            this.tradeCount = MathUtil.clamp(compound.m_128451_("TradeLimit"), 1, 32);
        }
        if (compound.m_128425_("Trades", 9)) {
            this.trades = ItemTradeData.loadAllData(compound, this.tradeCount);
        }
        if (compound.m_128425_("Storage", 9)) {
            this.storage.load(compound, "Storage");
            ListTag list = compound.m_128437_("Storage", 10);
            if (list.size() <= 0 || !list.m_128728_(0).m_128441_("Slot")) {
                this.storage.load(compound, "Storage");
            } else {
                SimpleContainer container = InventoryUtil.loadAllItems("Storage", compound, this.getTradeCount() * 9);
                this.storage.loadFromContainer((Container)container);
            }
        }
        if (compound.m_128425_("UpgradeInventory", 9)) {
            this.upgradeInventory = InventoryUtil.loadAllItems("UpgradeInventory", compound, 5);
        }
        this.logger.read(compound);
        if (compound.m_128425_("TradeRules", 9)) {
            this.tradeRules = TradeRule.readRules(compound);
        }
        if (compound.m_128425_("ItemSettings", 10)) {
            this.itemSettings.load(compound.m_128469_("ItemSettings"));
        }
        super.read(compound);
    }

    @Override
    public CompoundTag write(CompoundTag compound) {
        this.writeTrades(compound);
        this.writeStorage(compound);
        this.writeUpgrades(compound);
        this.writeLogger(compound);
        this.writeRules(compound);
        this.writeItemSettings(compound);
        return super.write(compound);
    }

    protected final CompoundTag writeTrades(CompoundTag compound) {
        compound.m_128405_("TradeLimit", this.trades.size());
        ItemTradeData.saveAllData(compound, this.trades);
        return compound;
    }

    protected final CompoundTag writeStorage(CompoundTag compound) {
        this.storage.save(compound, "Storage");
        return compound;
    }

    protected final CompoundTag writeUpgrades(CompoundTag compound) {
        InventoryUtil.saveAllItems("UpgradeInventory", compound, this.upgradeInventory);
        return compound;
    }

    protected final CompoundTag writeLogger(CompoundTag compound) {
        this.logger.write(compound);
        return compound;
    }

    protected final CompoundTag writeRules(CompoundTag compound) {
        TradeRule.writeRules(compound, this.tradeRules);
        return compound;
    }

    protected final CompoundTag writeItemSettings(CompoundTag compound) {
        compound.m_128365_("ItemSettings", (Tag)this.itemSettings.save(new CompoundTag()));
        return compound;
    }

    @Override
    public int getTradeCount() {
        return this.tradeCount;
    }

    @Override
    public void requestAddOrRemoveTrade(boolean isAdd) {
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageAddOrRemoveTrade2(this.traderID, isAdd));
    }

    @Override
    public void addTrade(Player requestor) {
        if (!TradingOffice.isAdminPlayer(requestor)) {
            Settings.PermissionWarning(requestor, "add trade slot", "LC_ADMIN_MODE");
            return;
        }
        if (this.getTradeCount() >= 32) {
            return;
        }
        this.overrideTradeCount(this.tradeCount + 1);
        this.coreSettings.getLogger().LogAddRemoveTrade(requestor, true, this.tradeCount);
        this.markCoreSettingsDirty();
    }

    @Override
    public void removeTrade(Player requestor) {
        if (!TradingOffice.isAdminPlayer(requestor)) {
            Settings.PermissionWarning(requestor, "remove trade slot", "LC_ADMIN_MODE");
            return;
        }
        if (this.getTradeCount() <= 1) {
            return;
        }
        this.overrideTradeCount(this.tradeCount - 1);
        this.coreSettings.getLogger().LogAddRemoveTrade(requestor, true, this.tradeCount);
        this.markCoreSettingsDirty();
    }

    public void overrideTradeCount(int newTradeCount) {
        if (this.tradeCount == newTradeCount) {
            return;
        }
        this.tradeCount = MathUtil.clamp(newTradeCount, 1, 32);
        List<ItemTradeData> oldTrades = this.trades;
        this.trades = ItemTradeData.listOfSize(this.getTradeCount());
        for (int i = 0; i < oldTrades.size() && i < this.trades.size(); ++i) {
            this.trades.set(i, oldTrades.get(i));
        }
        CompoundTag compound = this.writeTrades(new CompoundTag());
        this.writeStorage(compound);
        this.markDirty(compound);
    }

    @Override
    public ItemTradeData getTrade(int tradeIndex) {
        if (tradeIndex >= 0 && tradeIndex < this.getTradeCount()) {
            return this.trades.get(tradeIndex);
        }
        return new ItemTradeData();
    }

    @Override
    public int getTradeStock(int tradeIndex) {
        return this.getTrade(tradeIndex).stockCount(this);
    }

    @Override
    public List<ItemTradeData> getAllTrades() {
        return this.trades;
    }

    @Override
    public void markTradesDirty() {
        this.markDirty((Function<CompoundTag, CompoundTag>)((Function)this::writeTrades));
    }

    @Override
    public ItemTraderSettings getItemSettings() {
        return this.itemSettings;
    }

    @Override
    public List<Settings> getAdditionalSettings() {
        return Lists.newArrayList();
    }

    @Override
    public void markItemSettingsDirty() {
        this.markDirty((Function<CompoundTag, CompoundTag>)((Function)this::writeItemSettings));
    }

    @Override
    public ItemShopLogger getLogger() {
        return this.logger;
    }

    @Override
    public void clearLogger() {
        this.logger.clear();
        this.markLoggerDirty();
    }

    @Override
    public void markLoggerDirty() {
        this.markDirty((Function<CompoundTag, CompoundTag>)((Function)this::writeLogger));
    }

    public int inventorySize() {
        return this.tradeCount * 9;
    }

    @Override
    public TraderItemStorage getStorage() {
        return this.storage;
    }

    @Override
    public void markStorageDirty() {
        this.markDirty((Function<CompoundTag, CompoundTag>)((Function)this::writeStorage));
    }

    @Override
    public ResourceLocation getTraderType() {
        return TYPE;
    }

    @Override
    protected Component getDefaultName() {
        return new TranslatableComponent("gui.lightmanscurrency.universaltrader.item");
    }

    @Override
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_TRADER;
    }

    @Override
    public int GetCurrentVersion() {
        return 1;
    }

    @Override
    protected void onVersionUpdate(int oldVersion) {
        if (oldVersion < 1) {
            for (ItemTradeData trade : this.trades) {
                this.storage.forceAddItem(trade.getSellItem(0));
            }
        }
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        this.tradeRules.forEach(rule -> rule.beforeTrade(event));
    }

    @Override
    public void tradeCost(TradeEvent.TradeCostEvent event) {
        this.tradeRules.forEach(rule -> rule.tradeCost(event));
    }

    @Override
    public void afterTrade(TradeEvent.PostTradeEvent event) {
        this.tradeRules.forEach(rule -> rule.afterTrade(event));
    }

    @Override
    public List<TradeRule> getRules() {
        return this.tradeRules;
    }

    public void setRules(List<TradeRule> rules) {
        this.tradeRules = rules;
    }

    public void addRule(TradeRule newRule) {
        if (newRule == null) {
            return;
        }
        for (int i = 0; i < this.tradeRules.size(); ++i) {
            if (newRule.type != this.tradeRules.get((int)i).type) continue;
            return;
        }
        this.tradeRules.add(newRule);
    }

    public void removeRule(TradeRule rule) {
        if (this.tradeRules.contains(rule)) {
            this.tradeRules.remove(rule);
        }
    }

    @Override
    public void clearRules() {
        this.tradeRules.clear();
    }

    @Override
    public void markRulesDirty() {
        this.markDirty((Function<CompoundTag, CompoundTag>)((Function)this::writeRules));
    }

    @Override
    public ITradeRuleScreenHandler getRuleScreenHandler(int tradeIndex) {
        return new TradeRuleScreenHandler(this, tradeIndex);
    }

    @Override
    public void sendTradeRuleUpdateMessage(int tradeIndex, ResourceLocation type, CompoundTag updateInfo) {
        if (this.isClient()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageUpdateTradeRule2(this.traderID, tradeIndex, type, updateInfo));
        }
    }

    @Override
    public CompoundTag getPersistentData() {
        CompoundTag data = new CompoundTag();
        ITradeRuleHandler.savePersistentRuleData(data, this, this.trades);
        this.logger.write(data);
        return data;
    }

    @Override
    public void loadPersistentData(CompoundTag data) {
        ITradeRuleHandler.readPersistentRuleData(data, this, this.trades);
        this.logger.read(data);
    }

    @Override
    public void loadFromJson(JsonObject json) throws Exception {
        super.loadFromJson(json);
        if (!json.has("Trades")) {
            throw new Exception("Item Trader must have a trade list.");
        }
        JsonArray tradeList = json.get("Trades").getAsJsonArray();
        this.trades = new ArrayList<ItemTradeData>();
        for (int i = 0; i < tradeList.size() && this.trades.size() < 32; ++i) {
            try {
                JsonObject tradeData = tradeList.get(i).getAsJsonObject();
                ItemTradeData newTrade = new ItemTradeData();
                JsonObject sellItem = tradeData.get("SellItem").getAsJsonObject();
                newTrade.setItem(FileUtil.parseItemStack(sellItem), 0);
                if (tradeData.has("SellItem2")) {
                    newTrade.setItem(FileUtil.parseItemStack(tradeData.get("SellItem2").getAsJsonObject()), 1);
                }
                if (tradeData.has("TradeType")) {
                    newTrade.setTradeType(ItemTradeData.loadTradeType(tradeData.get("TradeType").getAsString()));
                }
                if (tradeData.has("Price")) {
                    if (newTrade.isBarter()) {
                        LightmansCurrency.LogWarning("Price is being defined for a barter trade. Price will be ignored.");
                    } else {
                        newTrade.setCost(CoinValue.Parse(tradeData.get("Price")));
                    }
                } else if (!newTrade.isBarter()) {
                    LightmansCurrency.LogWarning("Price is not defined on a non-barter trade. Price will be assumed to be free.");
                    newTrade.getCost().setFree(true);
                }
                if (tradeData.has("BarterItem")) {
                    if (newTrade.isBarter()) {
                        JsonObject barterItem = tradeData.get("BarterItem").getAsJsonObject();
                        newTrade.setItem(FileUtil.parseItemStack(barterItem), 2);
                        if (tradeData.has("BarterItem2")) {
                            newTrade.setItem(FileUtil.parseItemStack(tradeData.get("BarterItem2").getAsJsonObject()), 3);
                        }
                    } else {
                        LightmansCurrency.LogWarning("BarterItem is being defined for a non-barter trade. Barter item will be ignored.");
                    }
                }
                if (tradeData.has("DisplayName")) {
                    newTrade.setCustomName(0, tradeData.get("DisplayName").getAsString());
                }
                if (tradeData.has("DisplayName2")) {
                    newTrade.setCustomName(1, tradeData.get("DisplayName2").getAsString());
                }
                if (tradeData.has("TradeRules")) {
                    newTrade.setRules(TradeRule.Parse(tradeData.get("TradeRules").getAsJsonArray()));
                }
                this.trades.add(newTrade);
            }
            catch (Exception e) {
                LightmansCurrency.LogError("Error parsing item trade at index " + i, e);
            }
            if (this.trades.size() <= 0) {
                throw new Exception("Trader has no valid trades!");
            }
            this.tradeCount = this.trades.size();
            this.storage = new TraderItemStorage.LockedTraderStorage(this);
        }
        if (json.has("TradeRules")) {
            this.tradeRules = TradeRule.Parse(json.get("TradeRules").getAsJsonArray());
        }
    }

    @Override
    public JsonObject saveToJson(JsonObject json) {
        super.saveToJson(json);
        JsonArray trades = new JsonArray();
        for (ItemTradeData trade : this.trades) {
            if (!trade.isValid()) continue;
            JsonObject tradeData = new JsonObject();
            tradeData.addProperty("TradeType", trade.getTradeType().name());
            if (trade.getSellItem(0).m_41619_()) {
                tradeData.add("SellItem", (JsonElement)FileUtil.convertItemStack(trade.getSellItem(1)));
                if (trade.hasCustomName(0)) {
                    tradeData.addProperty("DisplayName", trade.getCustomName(0));
                }
            } else {
                tradeData.add("SellItem", (JsonElement)FileUtil.convertItemStack(trade.getSellItem(0)));
                if (trade.hasCustomName(0)) {
                    tradeData.addProperty("DisplayName", trade.getCustomName(0));
                }
                if (!trade.getSellItem(1).m_41619_()) {
                    tradeData.add("SellItem2", (JsonElement)FileUtil.convertItemStack(trade.getSellItem(1)));
                    if (trade.hasCustomName(1)) {
                        tradeData.addProperty("DisplayName2", trade.getCustomName(1));
                    }
                }
            }
            if (trade.isSale() || trade.isPurchase()) {
                tradeData.add("Price", trade.getCost().toJson());
            }
            if (trade.isBarter()) {
                if (trade.getBarterItem(0).m_41619_()) {
                    tradeData.add("BarterItem", (JsonElement)FileUtil.convertItemStack(trade.getBarterItem(1)));
                } else {
                    tradeData.add("BarterItem", (JsonElement)FileUtil.convertItemStack(trade.getBarterItem(0)));
                    if (!trade.getBarterItem(1).m_41619_()) {
                        tradeData.add("BarterItem2", (JsonElement)FileUtil.convertItemStack(trade.getBarterItem(1)));
                    }
                }
            }
            if (trade.getRules().size() > 0) {
                tradeData.add("TradeRules", (JsonElement)TradeRule.saveRulesToJson(trade.getRules()));
            }
            trades.add((JsonElement)tradeData);
        }
        json.add("Trades", (JsonElement)trades);
        if (this.tradeRules.size() > 0) {
            json.add("TradeRules", (JsonElement)TradeRule.saveRulesToJson(this.tradeRules));
        }
        return json;
    }

    @Override
    public boolean canInteractRemotely() {
        return true;
    }

    @Override
    public void receiveTradeRuleMessage(Player player, int index, ResourceLocation ruleType, CompoundTag updateInfo) {
        if (!this.hasPermission(player, "editTradeRules")) {
            Settings.PermissionWarning(player, "edit trade rule", "editTradeRules");
            return;
        }
        if (index >= 0) {
            this.getTrade(index).updateRule(ruleType, updateInfo);
        } else {
            this.updateRule(ruleType, updateInfo);
        }
    }

    private static class TradeRuleScreenHandler
    implements ITradeRuleScreenHandler {
        private final UniversalItemTraderData trader;
        private final int tradeIndex;

        public TradeRuleScreenHandler(UniversalItemTraderData trader, int tradeIndex) {
            this.trader = trader;
            this.tradeIndex = tradeIndex;
        }

        @Override
        public ITradeRuleHandler ruleHandler() {
            if (this.tradeIndex < 0) {
                return this.trader;
            }
            return this.trader.getTrade(this.tradeIndex);
        }

        @Override
        public void reopenLastScreen() {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageOpenStorage2(this.trader.traderID));
        }

        @Override
        public void updateServer(ResourceLocation type, CompoundTag updateInfo) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageUpdateTradeRule2(this.trader.traderID, this.tradeIndex, type, updateInfo));
        }

        @Override
        public boolean stillValid() {
            return ClientTradingOffice.getData(this.trader.traderID) != null;
        }
    }
}

