/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.core.ModRecipes;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class WalletUpgradeRecipeBuilder {
    private String group;
    private final Item result;
    private final List<Ingredient> ingredients = Lists.newArrayList();

    public WalletUpgradeRecipeBuilder(ItemLike walletInput, ItemLike result, Ingredient ... ingredients) {
        this(walletInput, result, "", ingredients);
    }

    public WalletUpgradeRecipeBuilder(ItemLike walletInput, ItemLike result, String group, Ingredient ... ingredients) {
        this.group = group;
        this.result = result.m_5456_();
        this.ingredients.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{walletInput}));
        for (Ingredient i : ingredients) {
            this.addIngredient(i, 1);
        }
    }

    public static WalletUpgradeRecipeBuilder walletUpgrade(ItemLike walletIn, ItemLike walletOut, String group, Ingredient ... ingredients) {
        return new WalletUpgradeRecipeBuilder(walletIn, walletOut, group, ingredients);
    }

    public static WalletUpgradeRecipeBuilder walletUpgrade(ItemLike walletIn, ItemLike walletOut, Ingredient ... ingredients) {
        return new WalletUpgradeRecipeBuilder(walletIn, walletOut, ingredients);
    }

    public WalletUpgradeRecipeBuilder addIngredient(TagKey<Item> tagIn) {
        return this.addIngredient(Ingredient.m_204132_(tagIn));
    }

    public WalletUpgradeRecipeBuilder addIngredient(ItemLike itemIn) {
        return this.addIngredient(itemIn, 1);
    }

    public WalletUpgradeRecipeBuilder addIngredient(ItemLike itemIn, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.addIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemIn}));
        }
        return this;
    }

    public WalletUpgradeRecipeBuilder addIngredient(Ingredient ingredientIn) {
        return this.addIngredient(ingredientIn, 1);
    }

    public WalletUpgradeRecipeBuilder addIngredient(Ingredient ingredientIn, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add(ingredientIn);
        }
        return this;
    }

    public WalletUpgradeRecipeBuilder setGroup(String groupIn) {
        this.group = groupIn;
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer, String name) {
        this.save(consumer, new ResourceLocation(name));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.result, this.group, this.ingredients));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final String group;
        private final List<Ingredient> ingredients;

        public Result(ResourceLocation idIn, Item resultIn, String groupIn, List<Ingredient> ingredientsIn) {
            this.id = idIn;
            this.result = resultIn;
            this.group = groupIn;
            this.ingredients = ingredientsIn;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray jsonarray = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                jsonarray.add(ingredient.m_43942_());
            }
            json.add("ingredients", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", this.result.getRegistryName().toString());
            json.add("result", (JsonElement)jsonobject);
        }

        public RecipeSerializer<?> m_6637_() {
            return ModRecipes.WALLET_UPGRADE;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

