/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.items;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.upgrades.UpgradeType;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public abstract class UpgradeItem
extends Item
implements UpgradeType.IUpgradeItem {
    protected final UpgradeType upgradeType;
    private boolean addTooltips = true;
    Function<UpgradeType.UpgradeData, List<Component>> customTooltips = null;

    public UpgradeItem(UpgradeType upgradeType, Item.Properties properties) {
        super(properties);
        this.upgradeType = upgradeType;
    }

    public final boolean addsTooltips() {
        return this.addTooltips;
    }

    protected final void ignoreTooltips() {
        this.addTooltips = false;
    }

    protected final void setCustomTooltips(Function<UpgradeType.UpgradeData, List<Component>> customTooltips) {
        this.customTooltips = customTooltips;
    }

    @Override
    public UpgradeType getUpgradeType() {
        return this.upgradeType;
    }

    @Override
    public UpgradeType.UpgradeData getDefaultUpgradeData() {
        UpgradeType.UpgradeData data = this.upgradeType.getDefaultData();
        this.fillUpgradeData(data);
        return data;
    }

    protected abstract void fillUpgradeData(UpgradeType.UpgradeData var1);

    public static UpgradeType.UpgradeData getUpgradeData(ItemStack stack) {
        if (stack.m_41720_() instanceof UpgradeItem) {
            CompoundTag tag;
            UpgradeType.UpgradeData data = ((UpgradeItem)stack.m_41720_()).getDefaultUpgradeData();
            if (stack.m_41782_() && (tag = stack.m_41783_()).m_128425_("UpgradeData", 10)) {
                data.read(tag.m_128469_("UpgradeData"));
            }
            return data;
        }
        return null;
    }

    public static void setUpgradeData(ItemStack stack, UpgradeType.UpgradeData data) {
        if (stack.m_41720_() instanceof UpgradeItem) {
            UpgradeType source = ((UpgradeItem)stack.m_41720_()).upgradeType;
            CompoundTag tag = stack.m_41784_();
            tag.m_128365_("UpgradeData", (Tag)data.writeToNBT(source));
        } else {
            CompoundTag tag = stack.m_41784_();
            tag.m_128365_("UpgradeData", (Tag)data.writeToNBT());
        }
    }

    public static List<Component> getUpgradeTooltip(ItemStack stack) {
        return UpgradeItem.getUpgradeTooltip(stack, false);
    }

    public static List<Component> getUpgradeTooltip(ItemStack stack, boolean forceCollection) {
        if (stack.m_41720_() instanceof UpgradeItem) {
            UpgradeItem item = (UpgradeItem)stack.m_41720_();
            if (!item.addTooltips && !forceCollection) {
                return Lists.newArrayList();
            }
            UpgradeType type = item.getUpgradeType();
            UpgradeType.UpgradeData data = UpgradeItem.getUpgradeData(stack);
            if (item.customTooltips != null) {
                return (List)item.customTooltips.apply((Object)data);
            }
            return type.getTooltip(data);
        }
        return Lists.newArrayList();
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        List<Component> upgradeTooltips = UpgradeItem.getUpgradeTooltip(stack);
        if (upgradeTooltips != null) {
            upgradeTooltips.forEach(upgradeTooltip -> tooltip.add((Component)upgradeTooltip));
        }
        super.m_7373_(stack, level, tooltip, flagIn);
    }
}

