/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.menus.traderstorage.paygate;

import io.github.lightman314.lightmanscurrency.blockentity.PaygateBlockEntity;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.paygate.PaygateTradeEditClientTab;
import io.github.lightman314.lightmanscurrency.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.menus.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.menus.traderstorage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.trader.tradedata.PaygateTradeData;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PaygateTradeEditTab
extends TraderStorageTab {
    private int tradeIndex = -1;

    public PaygateTradeEditTab(TraderStorageMenu menu) {
        super(menu);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TraderStorageClientTab<?> createClientTab(TraderStorageScreen screen) {
        return new PaygateTradeEditClientTab(screen, this);
    }

    @Override
    public boolean canOpen(Player player) {
        return this.menu.getTrader().hasPermission(player, "editTrades");
    }

    public int getTradeIndex() {
        return this.tradeIndex;
    }

    public PaygateTradeData getTrade() {
        if (this.menu.getTrader() instanceof PaygateBlockEntity) {
            PaygateBlockEntity paygate = (PaygateBlockEntity)this.menu.getTrader();
            if (this.tradeIndex >= paygate.getTradeCount() || this.tradeIndex < 0) {
                this.menu.changeTab(0);
                this.menu.sendMessage(this.menu.createTabChangeMessage(0, null));
                return null;
            }
            return paygate.getTrade(this.tradeIndex);
        }
        return null;
    }

    @Override
    public void onTabOpen() {
    }

    @Override
    public void onTabClose() {
    }

    @Override
    public void addStorageMenuSlots(Function<Slot, Slot> addSlot) {
    }

    public void setTradeIndex(int tradeIndex) {
        this.tradeIndex = tradeIndex;
    }

    public void setPrice(CoinValue price) {
        PaygateTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setCost(price);
            this.menu.getTrader().markTradesDirty();
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                price.writeToNBT(message, "NewPrice");
                this.menu.sendMessage(message);
            }
        }
    }

    public void setTicket(UUID ticketID) {
        PaygateTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setTicketID(ticketID);
            this.menu.getTrader().markTradesDirty();
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                message.m_128379_("NewTicket", true);
                if (ticketID != null) {
                    message.m_128362_("TicketID", ticketID);
                }
                this.menu.sendMessage(message);
            }
        }
    }

    public void setDuration(int duration) {
        PaygateTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setDuration(duration);
            this.menu.getTrader().markTradesDirty();
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                message.m_128405_("NewDuration", duration);
                this.menu.sendMessage(message);
            }
        }
    }

    @Override
    public void receiveMessage(CompoundTag message) {
        if (message.m_128441_("TradeIndex")) {
            this.tradeIndex = message.m_128451_("TradeIndex");
        } else if (message.m_128441_("NewPrice")) {
            CoinValue price = new CoinValue(new CoinValue.CoinValuePair[0]);
            price.readFromNBT(message, "NewPrice");
            this.setPrice(price);
        } else if (message.m_128441_("NewTicket")) {
            UUID ticketID = null;
            if (message.m_128441_("TicketID")) {
                ticketID = message.m_128342_("TicketID");
            }
            this.setTicket(ticketID);
        } else if (message.m_128441_("NewDuration")) {
            this.setDuration(message.m_128451_("NewDuration"));
        }
    }
}

