/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.bank;

import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class MessageBankInteraction {
    boolean isDeposit;
    CoinValue amount;

    public MessageBankInteraction(boolean isDeposit, CoinValue amount) {
        this.isDeposit = isDeposit;
        this.amount = amount;
    }

    public static void encode(MessageBankInteraction message, FriendlyByteBuf buffer) {
        buffer.writeBoolean(message.isDeposit);
        buffer.m_130079_(message.amount.writeToNBT(new CompoundTag(), "CoinValue"));
    }

    public static MessageBankInteraction decode(FriendlyByteBuf buffer) {
        return new MessageBankInteraction(buffer.readBoolean(), new CoinValue(buffer.m_130261_()));
    }

    public static void handle(MessageBankInteraction message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && player.f_36096_ instanceof BankAccount.IBankAccountMenu) {
                BankAccount.IBankAccountMenu menu = (BankAccount.IBankAccountMenu)player.f_36096_;
                if (message.isDeposit) {
                    BankAccount.DepositCoins(menu, message.amount);
                } else {
                    BankAccount.WithdrawCoins(menu, message.amount);
                }
                menu.onDepositOrWithdraw();
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

