/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.trader;

import io.github.lightman314.lightmanscurrency.blockentity.TraderBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class MessageChangeSettings {
    private static final int MAX_TYPE_LENGTH = 100;
    BlockPos pos;
    ResourceLocation type;
    CompoundTag updateInfo;

    public MessageChangeSettings(BlockPos pos, ResourceLocation type, CompoundTag updateInfo) {
        this.pos = pos;
        this.type = type;
        this.updateInfo = updateInfo;
    }

    public static void encode(MessageChangeSettings message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.pos);
        buffer.m_130072_(message.type.toString(), 100);
        buffer.m_130079_(message.updateInfo);
    }

    public static MessageChangeSettings decode(FriendlyByteBuf buffer) {
        return new MessageChangeSettings(buffer.m_130135_(), new ResourceLocation(buffer.m_130136_(100)), buffer.m_130261_());
    }

    public static void handle(MessageChangeSettings message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            BlockEntity blockEntity;
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && (blockEntity = player.f_19853_.m_7702_(message.pos)) instanceof TraderBlockEntity) {
                TraderBlockEntity traderEntity = (TraderBlockEntity)blockEntity;
                traderEntity.changeSettings(message.type, (Player)player, message.updateInfo);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

