/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata.restrictions;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.trader.common.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemTradeRestriction {
    public static final ResourceLocation DEFAULT_BACKGROUND = new ResourceLocation("lightmanscurrency", "items/empty_item_slot");
    public static final Pair<ResourceLocation, ResourceLocation> BACKGROUND = Pair.of((Object)InventoryMenu.f_39692_, (Object)DEFAULT_BACKGROUND);
    static Map<ResourceLocation, ItemTradeRestriction> ITEM_TRADE_RESTRICTIONS;
    public static final ItemTradeRestriction NONE;

    public ItemStack modifySellItem(ItemStack sellItem, String customName, ItemTradeData trade) {
        return sellItem;
    }

    public boolean allowSellItem(ItemStack itemStack) {
        return true;
    }

    public ItemStack filterSellItem(ItemStack itemStack) {
        return itemStack;
    }

    public boolean allowItemSelectItem(ItemStack itemStack) {
        return true;
    }

    public boolean allowExtraItemInStorage(ItemStack itemStack) {
        return false;
    }

    public int getSaleStock(TraderItemStorage traderStorage, ItemStack ... sellItemList) {
        int minStock = Integer.MAX_VALUE;
        for (ItemStack sellItem : InventoryUtil.combineQueryItems(sellItemList)) {
            minStock = Math.min(this.getItemStock(sellItem, traderStorage), minStock);
        }
        return minStock;
    }

    protected final int getItemStock(ItemStack sellItem, TraderItemStorage traderStorage) {
        if (sellItem.m_41619_()) {
            return Integer.MAX_VALUE;
        }
        return traderStorage.getItemCount(sellItem) / sellItem.m_41613_();
    }

    public void removeItemsFromStorage(TraderItemStorage traderStorage, ItemStack ... sellItemList) {
        for (ItemStack sellItem : sellItemList) {
            this.removeFromStorage(sellItem, traderStorage);
        }
    }

    protected final void removeFromStorage(ItemStack sellItem, TraderItemStorage traderStorage) {
        if (sellItem.m_41619_()) {
            return;
        }
        traderStorage.removeItem(sellItem);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Pair<ResourceLocation, ResourceLocation> getEmptySlotBG() {
        return BACKGROUND;
    }

    static {
        NONE = new ItemTradeRestriction();
    }
}

