/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.IModelData;
import org.jetbrains.annotations.NotNull;
import xfacthd.framedblocks.client.model.FramedDoubleBlockModel;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.blockentity.FramedDoubleCornerBlockEntity;
import xfacthd.framedblocks.common.data.CornerType;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedDoubleCornerModel
extends FramedDoubleBlockModel {
    private final CornerType type;
    private final Direction facing;

    public FramedDoubleCornerModel(BlockState state, BakedModel baseModel) {
        super(baseModel, true);
        this.type = (CornerType)((Object)state.m_61143_(PropertyHolder.CORNER_TYPE));
        this.facing = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
    }

    @Override
    protected Tuple<BlockState, BlockState> getDummyStates() {
        return FramedDoubleCornerBlockEntity.getBlockPair(this.type, this.facing);
    }

    @Override
    public TextureAtlasSprite getParticleIcon(@NotNull IModelData data) {
        if (this.type == CornerType.BOTTOM) {
            return this.getSpriteOrDefault(data, FramedDoubleBlockEntity.DATA_RIGHT, (BakedModel)this.getModels().m_14418_());
        }
        if (this.type.isTop()) {
            return this.getSpriteOrDefault(data, FramedDoubleBlockEntity.DATA_LEFT, (BakedModel)this.getModels().m_14419_());
        }
        return super.getParticleIcon(data);
    }

    public static BlockState itemSource() {
        return (BlockState)((Block)FBContent.blockFramedDoubleCorner.get()).m_49966_().m_61124_((Property)PropertyHolder.FACING_HOR, (Comparable)Direction.WEST);
    }
}

