/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.api.util.client.BakedQuadTransformer;
import xfacthd.framedblocks.api.util.client.ModelUtils;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedLatticeModel
extends FramedBlockModel {
    private final boolean xAxis;
    private final boolean yAxis;
    private final boolean zAxis;

    public FramedLatticeModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.xAxis = (Boolean)state.m_61143_((Property)PropertyHolder.X_AXIS);
        this.yAxis = (Boolean)state.m_61143_((Property)PropertyHolder.Y_AXIS);
        this.zAxis = (Boolean)state.m_61143_((Property)PropertyHolder.Z_AXIS);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        if (quad.m_111306_() == Direction.UP || quad.m_111306_() == Direction.DOWN) {
            BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, 0.375f, 0.375f, 0.625f, 0.625f)) {
                if (this.yAxis) {
                    quadMap.get(quad.m_111306_()).add(topBotQuad);
                } else {
                    BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, 0.625f);
                    quadMap.get(null).add(topBotQuad);
                }
            }
            if (this.xAxis) {
                topBotQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, 0.0f, 0.375f, 0.375f, 0.625f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, 0.625f);
                    quadMap.get(null).add(topBotQuad);
                }
                if (BakedQuadTransformer.createTopBottomQuad(topBotQuad = ModelUtils.duplicateQuad(quad), 0.625f, 0.375f, 1.0f, 0.625f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, 0.625f);
                    quadMap.get(null).add(topBotQuad);
                }
            }
            if (this.zAxis) {
                topBotQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, 0.375f, 0.0f, 0.625f, 0.375f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, 0.625f);
                    quadMap.get(null).add(topBotQuad);
                }
                if (BakedQuadTransformer.createTopBottomQuad(topBotQuad = ModelUtils.duplicateQuad(quad), 0.375f, 0.625f, 0.625f, 1.0f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, 0.625f);
                    quadMap.get(null).add(topBotQuad);
                }
            }
        } else if (Utils.isX(quad.m_111306_())) {
            FramedLatticeModel.createHorizontalStrutSideQuads(quadMap, quad, this.xAxis, this.zAxis);
        } else if (Utils.isZ(quad.m_111306_())) {
            FramedLatticeModel.createHorizontalStrutSideQuads(quadMap, quad, this.zAxis, this.xAxis);
        }
        if (!Utils.isY(quad.m_111306_()) && this.yAxis) {
            BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSideQuad(sideQuad, 0.375f, 0.0f, 0.625f, 0.375f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.625f);
                quadMap.get(null).add(sideQuad);
            }
            if (BakedQuadTransformer.createSideQuad(sideQuad = ModelUtils.duplicateQuad(quad), 0.375f, 0.625f, 0.625f, 1.0f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.625f);
                quadMap.get(null).add(sideQuad);
            }
        }
    }

    private static void createHorizontalStrutSideQuads(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, boolean frontAxis, boolean sideAxis) {
        BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
        if (BakedQuadTransformer.createSideQuad(sideQuad, 0.375f, 0.375f, 0.625f, 0.625f)) {
            if (frontAxis) {
                quadMap.get(quad.m_111306_()).add(sideQuad);
            } else {
                BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.625f);
                quadMap.get(null).add(sideQuad);
            }
        }
        if (sideAxis) {
            sideQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSideQuad(sideQuad, 0.0f, 0.375f, 0.375f, 0.625f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.625f);
                quadMap.get(null).add(sideQuad);
            }
            if (BakedQuadTransformer.createSideQuad(sideQuad = ModelUtils.duplicateQuad(quad), 0.625f, 0.375f, 1.0f, 0.625f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.625f);
                quadMap.get(null).add(sideQuad);
            }
        }
    }
}

