/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.api.util.client.BakedQuadTransformer;
import xfacthd.framedblocks.api.util.client.ModelUtils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedSlopeSlabModel
extends FramedBlockModel {
    private static final float ANGLE = (float)(90.0 - Math.toDegrees(Math.atan(0.5)));
    private final Direction facing;
    private final boolean top;
    private final boolean topHalf;

    public FramedSlopeSlabModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        this.top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        this.topHalf = (Boolean)state.m_61143_((Property)PropertyHolder.TOP_HALF);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction face = quad.m_111306_();
        if (face == this.facing.m_122424_()) {
            BakedQuad slope = FramedSlopeSlabModel.createSlope(quad, this.facing, this.top);
            if (this.topHalf != this.top) {
                BakedQuadTransformer.offsetQuadInDir(slope, this.top ? Direction.DOWN : Direction.UP, 0.5f);
            }
            quadMap.get(null).add(slope);
        } else if (face == this.facing) {
            BakedQuad slabSide = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createHorizontalSideQuad(slabSide, this.topHalf, 0.5f)) {
                quadMap.get(face).add(slabSide);
            }
        } else if (face == this.facing.m_122427_() || face == this.facing.m_122428_()) {
            BakedQuad triangle = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSideTriangleQuad(triangle, face == this.facing.m_122427_(), this.top, 0.5f, this.topHalf == this.top ? 0.0f : 0.5f) && (this.topHalf == this.top || BakedQuadTransformer.createHorizontalSideQuad(triangle, !this.top, 0.5f))) {
                quadMap.get(face).add(triangle);
            }
        } else if (this.top && !this.topHalf && face == Direction.UP || !this.top && this.topHalf && face == Direction.DOWN) {
            BakedQuad topBottom = ModelUtils.duplicateQuad(quad);
            BakedQuadTransformer.setQuadPosInFacingDir(topBottom, 0.5f);
            quadMap.get(null).add(topBottom);
        }
    }

    public static BakedQuad createSlope(BakedQuad quad, Direction facing, boolean top) {
        Vector3f origin = new Vector3f(facing == Direction.WEST ? 1.0f : 0.0f, top ? 1.0f : 0.0f, facing == Direction.NORTH ? 1.0f : 0.0f);
        float angle = Utils.isPositive(facing) == top == Utils.isZ(facing) ? -ANGLE : ANGLE;
        BakedQuad slope = ModelUtils.duplicateQuad(quad);
        BakedQuadTransformer.rotateQuadAroundAxis(slope, facing.m_122427_().m_122434_(), origin, angle, true);
        return slope;
    }

    public static BlockState itemSource() {
        return (BlockState)((Block)FBContent.blockFramedSlopeSlab.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

