/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.util.client.BakedQuadTransformer;
import xfacthd.framedblocks.api.util.client.ModelUtils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.StairsType;

public class FramedVerticalStairsModel
extends FramedBlockModel {
    private final StairsType type;
    private final Direction dir;

    public FramedVerticalStairsModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.type = (StairsType)((Object)state.m_61143_(PropertyHolder.STAIRS_TYPE));
        this.dir = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        BakedQuad sideQuad;
        if (this.type == StairsType.VERTICAL && (quad.m_111306_() == this.dir.m_122424_() || quad.m_111306_() == this.dir.m_122427_())) {
            BakedQuad sideQuad2 = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createVerticalSideQuad(sideQuad2, quad.m_111306_() == this.dir.m_122424_() ? this.dir.m_122427_() : this.dir.m_122424_(), 0.5f)) {
                quadMap.get(quad.m_111306_()).add(sideQuad2);
            }
            if (BakedQuadTransformer.createVerticalSideQuad(sideQuad2 = ModelUtils.duplicateQuad(quad), quad.m_111306_() == this.dir.m_122424_() ? this.dir.m_122428_() : this.dir, 0.5f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(sideQuad2, 0.5f);
                quadMap.get(null).add(sideQuad2);
            }
        }
        if (quad.m_111306_() == Direction.UP && !this.type.isTop() || quad.m_111306_() == Direction.DOWN && !this.type.isBottom()) {
            BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, this.dir.m_122424_(), 0.5f)) {
                quadMap.get(quad.m_111306_()).add(topBotQuad);
            }
            if (BakedQuadTransformer.createTopBottomQuad(topBotQuad = ModelUtils.duplicateQuad(quad), this.dir, 0.5f) && BakedQuadTransformer.createTopBottomQuad(topBotQuad, this.dir.m_122427_(), 0.5f)) {
                quadMap.get(quad.m_111306_()).add(topBotQuad);
            }
        }
        if ((quad.m_111306_() == this.dir.m_122424_() || quad.m_111306_() == this.dir.m_122427_()) && this.type != StairsType.VERTICAL) {
            boolean opposite = quad.m_111306_() == this.dir.m_122424_();
            sideQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createVerticalSideQuad(sideQuad, opposite ? this.dir.m_122427_() : this.dir.m_122424_(), 0.5f) && BakedQuadTransformer.createHorizontalSideQuad(sideQuad, !this.type.isTop(), 0.5f)) {
                quadMap.get(quad.m_111306_()).add(sideQuad);
            }
            if (BakedQuadTransformer.createVerticalSideQuad(sideQuad = ModelUtils.duplicateQuad(quad), opposite ? this.dir.m_122428_() : this.dir, 0.5f) && BakedQuadTransformer.createHorizontalSideQuad(sideQuad, !this.type.isTop(), 0.5f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.5f);
                quadMap.get(null).add(sideQuad);
            }
            if (BakedQuadTransformer.createVerticalSideQuad(sideQuad = ModelUtils.duplicateQuad(quad), opposite ? this.dir.m_122427_() : this.dir.m_122424_(), 0.5f) && BakedQuadTransformer.createHorizontalSideQuad(sideQuad, this.type.isTop(), 0.5f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.5f);
                quadMap.get(null).add(sideQuad);
            }
        }
        if (quad.m_111306_() == Direction.UP && this.type.isTop() || quad.m_111306_() == Direction.DOWN && this.type.isBottom()) {
            BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, this.dir.m_122424_(), 0.5f) && BakedQuadTransformer.createTopBottomQuad(topBotQuad, this.dir.m_122427_(), 0.5f)) {
                quadMap.get(quad.m_111306_()).add(topBotQuad);
            }
            if (BakedQuadTransformer.createTopBottomQuad(topBotQuad = ModelUtils.duplicateQuad(quad), this.dir.m_122424_(), 0.5f) && BakedQuadTransformer.createTopBottomQuad(topBotQuad, this.dir.m_122428_(), 0.5f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, 0.5f);
                quadMap.get(null).add(topBotQuad);
            }
            if (BakedQuadTransformer.createTopBottomQuad(topBotQuad = ModelUtils.duplicateQuad(quad), this.dir, 0.5f) && BakedQuadTransformer.createTopBottomQuad(topBotQuad, this.dir.m_122427_(), 0.5f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, 0.5f);
                quadMap.get(null).add(topBotQuad);
            }
        }
        if ((quad.m_111306_() == this.dir || quad.m_111306_() == this.dir.m_122428_()) && this.type != StairsType.VERTICAL) {
            boolean ccw = quad.m_111306_() == this.dir.m_122428_();
            sideQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createHorizontalSideQuad(sideQuad, !this.type.isTop(), 0.5f)) {
                quadMap.get(quad.m_111306_()).add(sideQuad);
            }
            if (BakedQuadTransformer.createHorizontalSideQuad(sideQuad = ModelUtils.duplicateQuad(quad), this.type.isTop(), 0.5f) && BakedQuadTransformer.createVerticalSideQuad(sideQuad, ccw ? this.dir.m_122424_() : this.dir.m_122427_(), 0.5f)) {
                quadMap.get(quad.m_111306_()).add(sideQuad);
            }
        }
    }
}

