/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.Rotation;
import xfacthd.framedblocks.common.data.StairsType;

public class SlopePanelSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        Rotation rot = (Rotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        Direction rotDir = rot.withFacing(dir);
        boolean front = (Boolean)state.m_61143_((Property)PropertyHolder.FRONT);
        if (side == dir) {
            return !front && SideSkipPredicate.CTM.test(level, pos, state, adjState, side);
        }
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            return switch (type) {
                case BlockType.FRAMED_SLOPE_PANEL -> SlopePanelSkipPredicate.testAgainstSlopePanel(level, pos, dir, rot, rotDir, front, adjState, side);
                case BlockType.FRAMED_EXTENDED_SLOPE_PANEL -> SlopePanelSkipPredicate.testAgainstExtendedSlopePanel(level, pos, dir, rot, rotDir, front, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_PANEL -> SlopePanelSkipPredicate.testAgainstDoubleSlopePanel(level, pos, dir, rot, rotDir, front, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL -> SlopePanelSkipPredicate.testAgainstInverseDoubleSlopePanel(level, pos, dir, rot, rotDir, front, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> SlopePanelSkipPredicate.testAgainstSlabEdge(level, pos, dir, rot, rotDir, front, adjState, side);
                case BlockType.FRAMED_PANEL -> SlopePanelSkipPredicate.testAgainstPanel(level, pos, dir, rotDir, front, adjState, side);
                case BlockType.FRAMED_DOUBLE_PANEL -> SlopePanelSkipPredicate.testAgainstDoublePanel(level, pos, dir, rotDir, front, adjState, side);
                case BlockType.FRAMED_CORNER_PILLAR -> SlopePanelSkipPredicate.testAgainstCornerPillar(level, pos, dir, rot, rotDir, front, adjState, side);
                case BlockType.FRAMED_STAIRS -> SlopePanelSkipPredicate.testAgainstStairs(level, pos, dir, rot, rotDir, front, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> SlopePanelSkipPredicate.testAgainstDoubleStairs(level, pos, dir, rot, rotDir, front, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> SlopePanelSkipPredicate.testAgainstVerticalStairs(level, pos, dir, rot, rotDir, front, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS -> SlopePanelSkipPredicate.testAgainstVerticalDoubleStairs(level, pos, dir, rot, rotDir, front, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> SlopePanelSkipPredicate.testAgainstHalfStairs(level, pos, dir, rot, rotDir, front, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstSlopePanel(BlockGetter level, BlockPos pos, Direction dir, Rotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (side == rotDir.m_122424_() && adjRot == rot.getOpposite() && (adjDir == dir && adjFront == front || adjDir == dir.m_122424_() && adjFront != front)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (side.m_122434_() != dir.m_122434_() && side.m_122434_() != rotDir.m_122434_() && adjDir == dir && adjRot == rot && adjFront == front) {
            return SideSkipPredicate.compareState(level, pos, side, rotDir.m_122424_(), rotDir);
        }
        return false;
    }

    private static boolean testAgainstExtendedSlopePanel(BlockGetter level, BlockPos pos, Direction dir, Rotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        if (side != rotDir.m_122424_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjRot == rot && (adjDir == dir && !front || adjDir == dir.m_122424_() && front)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopePanel(BlockGetter level, BlockPos pos, Direction dir, Rotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (side == rotDir.m_122424_() && (adjRot == rot || adjRot == rot.getOpposite()) && (adjDir == dir && adjFront == front || adjDir == dir.m_122424_() && adjFront != front)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (side.m_122434_() != dir.m_122434_() && side.m_122434_() != rotDir.m_122434_() && (adjDir == dir && adjRot == rot && adjFront == front || adjDir == dir.m_122424_() && adjRot == rot.getOpposite() && adjFront != front)) {
            return SideSkipPredicate.compareState(level, pos, side, rotDir.m_122424_(), rotDir.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstInverseDoubleSlopePanel(BlockGetter level, BlockPos pos, Direction dir, Rotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        if (side != rotDir.m_122424_() && (side.m_122434_() == dir.m_122434_() || side.m_122434_() == rotDir.m_122434_())) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (side == rotDir.m_122424_() && adjRot == rot && (adjDir == dir && !front || adjDir == dir.m_122424_() && front)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (side != rotDir.m_122424_() && front && (adjDir == dir && adjRot == rot || adjDir == dir.m_122424_() && adjRot == rot.getOpposite())) {
            return SideSkipPredicate.compareState(level, pos, side, rotDir.m_122424_(), rotDir.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstSlabEdge(BlockGetter level, BlockPos pos, Direction dir, Rotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        if (!rot.isVertical() || side != rotDir.m_122424_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop == (rot == Rotation.UP) && (adjDir == dir && !front || adjDir == dir.m_122424_() && front)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstPanel(BlockGetter level, BlockPos pos, Direction dir, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        if (side != rotDir.m_122424_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (adjDir == dir && !front || adjDir == dir.m_122424_() && front) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstDoublePanel(BlockGetter level, BlockPos pos, Direction dir, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        if (side != rotDir.m_122424_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_NE);
        return (adjDir == dir || adjDir == dir.m_122424_()) && SideSkipPredicate.compareState(level, pos, side, side, front ? dir.m_122424_() : dir);
    }

    private static boolean testAgainstCornerPillar(BlockGetter level, BlockPos pos, Direction dir, Rotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        if (rot.isVertical() || side != rotDir.m_122424_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (!front && (adjDir == dir || adjDir == dir.m_122427_()) || front && (adjDir == dir.m_122424_() || adjDir == dir.m_122428_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, Direction dir, Rotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        boolean adjTop;
        if (!rot.isVertical() || side != rotDir.m_122424_()) {
            return false;
        }
        if (adjState.m_61143_((Property)StairBlock.f_56843_) != StairsShape.STRAIGHT) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)StairBlock.f_56841_);
        boolean bl = adjTop = adjState.m_61143_((Property)StairBlock.f_56842_) == Half.TOP;
        if (!front && adjDir == dir || front && adjDir == dir.m_122424_()) {
            return adjTop == (rot == Rotation.DOWN) && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstDoubleStairs(BlockGetter level, BlockPos pos, Direction dir, Rotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        if (!rot.isVertical() || side != rotDir.m_122424_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)StairBlock.f_56841_);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if ((adjDir == dir || adjDir == dir.m_122424_()) && adjTop == (rot == Rotation.DOWN)) {
            return SideSkipPredicate.compareState(level, pos, side, side, front ? dir.m_122424_() : dir);
        }
        return false;
    }

    private static boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, Direction dir, Rotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        if (rot.isVertical() || side != rotDir.m_122424_()) {
            return false;
        }
        if (adjState.m_61143_(PropertyHolder.STAIRS_TYPE) != StairsType.VERTICAL) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (!front && (adjDir == dir && rot == Rotation.RIGHT || adjDir == dir.m_122427_() && rot == Rotation.LEFT)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (front && (adjDir == dir.m_122424_() && rot == Rotation.LEFT || adjDir == dir.m_122428_() && rot == Rotation.RIGHT)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstVerticalDoubleStairs(BlockGetter level, BlockPos pos, Direction dir, Rotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        if (rot.isVertical() || side != rotDir.m_122424_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (!front && (adjDir == dir && rot == Rotation.RIGHT || adjDir == dir.m_122427_() && rot == Rotation.LEFT)) {
            return SideSkipPredicate.compareState(level, pos, side, side, adjDir);
        }
        if (front && (adjDir == dir.m_122424_() && rot == Rotation.LEFT || adjDir == dir.m_122428_() && rot == Rotation.RIGHT)) {
            return SideSkipPredicate.compareState(level, pos, side, side, adjDir);
        }
        if (front && (adjDir == dir || adjDir == dir.m_122427_()) || !front && (adjDir == dir.m_122424_() || adjDir == dir.m_122428_())) {
            return SideSkipPredicate.compareState(level, pos, side, side, adjDir.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstHalfStairs(BlockGetter level, BlockPos pos, Direction dir, Rotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        if (side != rotDir.m_122424_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (rot.isVertical()) {
            if ((Boolean)adjState.m_61143_((Property)FramedProperties.TOP) != (rot == Rotation.UP)) {
                return false;
            }
            if (!adjRight && (adjDir == dir.m_122427_() && !front || adjDir == dir.m_122428_() && front)) {
                return SideSkipPredicate.compareState(level, pos, side);
            }
            if (adjRight && (adjDir == dir.m_122428_() && !front || adjDir == dir.m_122427_() && front)) {
                return SideSkipPredicate.compareState(level, pos, side);
            }
        } else if (adjDir == side.m_122424_()) {
            if (!adjRight && (adjDir == dir.m_122427_() && !front || adjDir == dir.m_122428_() && front)) {
                return SideSkipPredicate.compareState(level, pos, side);
            }
            if (adjRight && (adjDir == dir.m_122428_() && !front || adjDir == dir.m_122427_() && front)) {
                return SideSkipPredicate.compareState(level, pos, side);
            }
        }
        return false;
    }
}

