/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.skippreds.StairsSkipPredicate;

public class SlopeSlabSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        if (SideSkipPredicate.CTM.test(level, pos, state, adjState, side)) {
            return true;
        }
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            boolean topHalf = (Boolean)state.m_61143_((Property)PropertyHolder.TOP_HALF);
            return switch (type) {
                case BlockType.FRAMED_SLOPE_SLAB -> SlopeSlabSkipPredicate.testAgainstSlopeSlab(level, pos, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_SLAB -> SlopeSlabSkipPredicate.testAgainstElevatedSlopeSlab(level, pos, dir, topHalf, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_SLAB -> SlopeSlabSkipPredicate.testAgainstDoubleSlopeSlab(level, pos, dir, topHalf, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_SLAB -> SlopeSlabSkipPredicate.testAgainstInverseDoubleSlopeSlab(level, pos, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_SLAB -> SlopeSlabSkipPredicate.testAgainstSlab(level, pos, dir, topHalf, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLAB -> SlopeSlabSkipPredicate.testAgainstDoubleSlab(level, pos, dir, topHalf, side);
                case BlockType.FRAMED_SLAB_EDGE -> SlopeSlabSkipPredicate.testAgainstSlabEdge(level, pos, dir, topHalf, adjState, side);
                case BlockType.FRAMED_STAIRS -> SlopeSlabSkipPredicate.testAgainstStairs(level, pos, dir, topHalf, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> SlopeSlabSkipPredicate.testAgainstDoubleStairs(level, pos, dir, topHalf, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> SlopeSlabSkipPredicate.testAgainstVerticalHalfStairs(level, pos, dir, topHalf, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (adjTopHalf != topHalf) {
            return false;
        }
        if (side == dir.m_122427_() || side == dir.m_122428_()) {
            return adjDir == dir && adjTop == top && SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (side == dir) {
            return adjDir == dir.m_122424_() && SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstElevatedSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return side == dir && adjDir == dir && adjTop == topHalf && SideSkipPredicate.compareState(level, pos, side, dir, dir);
    }

    private static boolean testAgainstDoubleSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (adjTopHalf != topHalf) {
            return false;
        }
        if (side == dir.m_122427_() || side == dir.m_122428_()) {
            return (adjDir == dir || adjDir == dir.m_122424_()) && SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (side == dir) {
            return (adjDir == dir || adjDir == dir.m_122424_()) && SideSkipPredicate.compareState(level, pos, side, dir, dir.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstInverseDoubleSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (side == dir.m_122427_() || side == dir.m_122428_()) {
            return (adjDir == dir && topHalf && !top || adjDir == dir.m_122424_() && !topHalf && top) && SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (side == dir && (adjDir == dir && !topHalf || adjDir == dir.m_122424_() && topHalf)) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstSlab(BlockGetter level, BlockPos pos, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return side == dir && adjTop == topHalf && SideSkipPredicate.compareState(level, pos, side, dir, dir);
    }

    private static boolean testAgainstDoubleSlab(BlockGetter level, BlockPos pos, Direction dir, boolean topHalf, Direction side) {
        return side == dir && SideSkipPredicate.compareState(level, pos, side, dir, topHalf ? Direction.UP : Direction.DOWN);
    }

    private static boolean testAgainstSlabEdge(BlockGetter level, BlockPos pos, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return side == dir && adjDir == dir.m_122424_() && adjTop == topHalf && SideSkipPredicate.compareState(level, pos, side, dir, dir);
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        boolean adjTop;
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)BlockStateProperties.f_61398_);
        boolean bl = adjTop = adjState.m_61143_((Property)BlockStateProperties.f_61402_) == Half.TOP;
        if (topHalf == adjTop && StairsSkipPredicate.isSlabSide(adjShape, adjDir, side.m_122424_())) {
            return side == dir && SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstDoubleStairs(BlockGetter level, BlockPos pos, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        if (adjDir == dir && side == dir) {
            return SideSkipPredicate.compareState(level, pos, side, dir, topHalf ? Direction.UP : Direction.DOWN);
        }
        return false;
    }

    private static boolean testAgainstVerticalHalfStairs(BlockGetter level, BlockPos pos, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop != topHalf || side != dir) {
            return false;
        }
        if (adjDir == dir.m_122424_() || adjDir == dir.m_122428_()) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }
}

