/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.items;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.items.DamageableItem;
import com.endertech.minecraft.forge.units.IForgeUnit;
import com.endertech.minecraft.forge.units.UnitEnabled;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ForgeItem
extends Item
implements IForgeUnit<Item> {
    private final UnitEnabled unitEnabled;
    private final UnitConfig config;

    public ForgeItem(AbstractForgeMod mod, UnitConfig config, Item.Properties properties) {
        this(mod, config, "", properties);
    }

    public ForgeItem(AbstractForgeMod mod, UnitConfig config, String name, Item.Properties properties) {
        super(properties);
        this.setRegistryName(new ResourceLocation(mod.getId(), name));
        this.config = config;
        this.unitEnabled = new UnitEnabled(config, this.getUnitCategory(), true);
    }

    public static ResourceLocation getRegistryName(Item item) {
        return ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item);
    }

    public static UUID getAttackDamageModifierUUID() {
        return f_41374_;
    }

    public static UUID getAttackSpeedModifierUUID() {
        return f_41375_;
    }

    public static String getStringId(Item item) {
        return item.getRegistryName().toString();
    }

    protected boolean m_41389_(CreativeModeTab group) {
        return this.isEnabled() ? super.m_41389_(group) : false;
    }

    @Override
    public boolean isEnabled() {
        return this.unitEnabled.isEnabled();
    }

    @Override
    public UnitConfig getConfig() {
        return this.config;
    }

    public static <T extends LivingEntity> void damageItem(int damage, ItemStack stack, boolean destroyBroken, @Nullable T damager, @Nullable Consumer<T> onBroken) {
        ServerPlayer player;
        ServerPlayer serverPlayer = player = damager instanceof ServerPlayer ? (ServerPlayer)damager : null;
        if (player == null || player.m_7500_()) {
            return;
        }
        Item item = stack.m_41720_();
        if (item instanceof DamageableItem) {
            ((DamageableItem)item).updateDurability(stack, player);
        }
        if (stack != null && stack.m_41763_()) {
            if (stack.m_41629_(damage, (Random)CommonMath.RANDOM, player)) {
                stack.m_41721_(stack.m_41776_());
            }
            if (ForgeItem.isBroken(stack)) {
                if (damager != null && onBroken != null) {
                    onBroken.accept(damager);
                }
                if (destroyBroken) {
                    stack.m_41774_(1);
                    stack.m_41721_(0);
                }
                if (player != null) {
                    player.m_36246_(Stats.f_12983_.m_12902_((Object)item));
                }
            }
        }
    }

    public static boolean isBroken(ItemStack stack) {
        return stack.m_41763_() && stack.m_41773_() >= stack.m_41776_();
    }

    public static boolean notBroken(ItemStack stack) {
        return !ForgeItem.isBroken(stack);
    }

    public static Optional<Integer> indexIn(Inventory inventory, Predicate<ItemStack> predicate) {
        int size = inventory.m_6643_();
        for (int i = 0; i < size; ++i) {
            if (!predicate.test(inventory.m_8020_(i))) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    public static boolean isRegistered(Item item) {
        return ForgeRegistries.ITEMS.containsValue((IForgeRegistryEntry)item);
    }
}

