/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.world_pre_generator.elements.commands.arguments.world_pos;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.data.WorldPos;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.WorldCoordinate;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.phys.Vec3;

public class WorldPosArgument
implements ArgumentType<Coordinates> {
    public static final String registry_name = "world_pos";
    private static final Collection<String> EXAMPLES = Arrays.asList("0 0", "~ ~", "1 -5", "~1 ~-2");
    private static final SimpleCommandExceptionType WORLD_POS_INCOMPLETE = new SimpleCommandExceptionType((Message)new TextComponent("Incomplete (expected 2 coordinates)"));

    public static WorldPosArgument worldPos() {
        return new WorldPosArgument();
    }

    public static WorldPos getWorldPos(CommandContext<CommandSourceStack> context, String name) {
        Vec3 vec3 = ((Coordinates)context.getArgument(name, Coordinates.class)).m_6955_((CommandSourceStack)context.getSource());
        return new WorldPos((int)vec3.f_82479_, (int)vec3.f_82481_);
    }

    public Coordinates parse(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        if (reader.canRead()) {
            WorldCoordinate x = WorldCoordinate.m_120869_((StringReader)reader);
            if (reader.canRead() && reader.peek() == ' ') {
                reader.skip();
                WorldCoordinate z = WorldCoordinate.m_120869_((StringReader)reader);
                return new WorldCoordinates(x, new WorldCoordinate(true, 0.0), z);
            }
            reader.setCursor(cursor);
            throw WORLD_POS_INCOMPLETE.createWithContext((ImmutableStringReader)reader);
        }
        throw WORLD_POS_INCOMPLETE.createWithContext((ImmutableStringReader)reader);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof SharedSuggestionProvider) {
            String remaining = builder.getRemaining();
            Set<SharedSuggestionProvider.TextCoordinates> suggestions = !remaining.isEmpty() && remaining.charAt(0) == '^' ? Collections.singleton(SharedSuggestionProvider.TextCoordinates.f_82987_) : ((SharedSuggestionProvider)context.getSource()).m_6284_();
            return SharedSuggestionProvider.m_82976_((String)remaining, suggestions, (SuggestionsBuilder)builder, (Predicate)Commands.m_82120_(this::parse));
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

