/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.mehvahdjukaar.supplementaries.client.renderers.RotHlpr;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BookPileBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BookPileHorizontalBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BookPileBlockTile;
import net.mehvahdjukaar.supplementaries.setup.ClientRegistry;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BookPileBlockTileRenderer
implements BlockEntityRenderer<BookPileBlockTile> {
    private final ModelPart book;
    private final ModelPart lock;

    public static LayerDefinition createMesh() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition book = root.m_171599_("book", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.0f, -5.0f, -4.0f, 4.0f, 10.0f, 7.0f).m_171514_(28, 6).m_171481_(1.0f, -5.0f, 3.0f, 1.0f, 10.0f, 1.0f).m_171514_(23, 6).m_171481_(-2.0f, -5.0f, 3.0f, 1.0f, 10.0f, 1.0f), PartPose.f_171404_);
        book.m_171599_("lock", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.0f, -1.0f, 3.0f, 2.0f, 2.0f, 1.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)32, (int)32);
    }

    public BookPileBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart model = context.m_173582_(ClientRegistry.BOOK_MODEL);
        this.book = model.m_171324_("book");
        this.lock = this.book.m_171324_("lock");
    }

    public void render(BookPileBlockTile tile, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int light, int overlay) {
        BlockState state = tile.m_58900_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        if (tile.horizontal) {
            this.renderHorizontal(tile.books, state, matrixStack, bufferIn, light, overlay);
        } else {
            this.renderVertical(tile, state, matrixStack, bufferIn, light, overlay);
        }
    }

    private void renderHorizontal(List<BookPileBlockTile.VisualBook> visualBooks, BlockState state, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        int books = Math.min((Integer)state.m_61143_((Property)BookPileBlock.BOOKS), visualBooks.size());
        Direction dir = (Direction)state.m_61143_((Property)BookPileHorizontalBlock.FACING);
        matrixStack.m_85845_(RotHlpr.rot(dir));
        matrixStack.m_85845_(RotHlpr.X90);
        matrixStack.m_85837_(0.0, 0.1875, 0.0);
        float angle = -0.19634955f;
        switch (books) {
            default: {
                break;
            }
            case 4: {
                matrixStack.m_85837_(-0.375, 0.0, 0.0);
                this.renderBook(matrixStack, buffer, light, overlay, visualBooks.get(0));
                matrixStack.m_85837_(0.25, 0.0, -0.0625);
                this.renderBook(matrixStack, buffer, light, overlay, visualBooks.get(1));
                matrixStack.m_85837_(0.25, 0.0, 0.0625);
                this.renderBook(matrixStack, buffer, light, overlay, visualBooks.get(2));
                matrixStack.m_85837_(0.25, 0.0, -0.0625);
                this.renderBook(matrixStack, buffer, light, overlay, visualBooks.get(3));
                break;
            }
            case 3: {
                matrixStack.m_85837_(-0.3125, 0.0, 0.0);
                this.renderBook(matrixStack, buffer, light, overlay, visualBooks.get(0));
                matrixStack.m_85837_(0.25, 0.0, -0.0625);
                this.renderBook(matrixStack, buffer, light, overlay, visualBooks.get(1));
                matrixStack.m_85837_(0.3125, 0.0, 0.0625);
                this.book.f_104205_ = angle;
                this.renderBook(matrixStack, buffer, light, overlay, visualBooks.get(2));
                this.book.f_104205_ = 0.0f;
                break;
            }
            case 2: {
                matrixStack.m_85837_(-0.1875, 0.0, 0.0);
                this.renderBook(matrixStack, buffer, light, overlay, visualBooks.get(0));
                matrixStack.m_85837_(0.3125, 0.0, 0.0625);
                this.book.f_104205_ = angle;
                this.renderBook(matrixStack, buffer, light, overlay, visualBooks.get(1));
                this.book.f_104205_ = 0.0f;
                break;
            }
            case 1: {
                this.renderBook(matrixStack, buffer, light, overlay, visualBooks.get(0));
            }
        }
    }

    private void renderVertical(BookPileBlockTile tile, BlockState state, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        int books = Math.min((Integer)state.m_61143_((Property)BookPileBlock.BOOKS), tile.books.size());
        matrixStack.m_85837_(0.0, -0.375, 0.0);
        this.book.f_104205_ = 1.5707964f;
        for (int i = 0; i < books; ++i) {
            BookPileBlockTile.VisualBook b = tile.books.get(i);
            this.book.f_104203_ = b.getAngle();
            this.renderBook(matrixStack, buffer, light, overlay, b);
            matrixStack.m_85837_(0.0, 0.25, 0.0);
        }
        this.book.f_104203_ = 0.0f;
        this.book.f_104205_ = 0.0f;
    }

    private void renderBook(PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay, BookPileBlockTile.VisualBook b) {
        VertexConsumer builder = b.getBuilder(buffer);
        this.lock.f_104207_ = b.isEnchanted();
        this.book.m_104301_(matrixStack, builder, light, overlay);
    }
}

