/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.skillcloaks.client.curio;

import java.util.function.Supplier;
import net.mindoth.skillcloaks.client.model.CloakModel;
import net.mindoth.skillcloaks.client.model.HoodModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.EntityRenderersEvent;

public class CurioLayers {
    public static final ModelLayerLocation SKILLCLOAK = CurioLayers.createLayerLocation("skillcloak");
    public static final ModelLayerLocation HOOD = CurioLayers.createLayerLocation("hood");

    public static ModelLayerLocation createLayerLocation(String name) {
        return new ModelLayerLocation(new ResourceLocation("skillcloaks", name), name);
    }

    private static Supplier<LayerDefinition> layer(MeshDefinition mesh, int textureWidth, int textureHeight) {
        return () -> LayerDefinition.m_171565_((MeshDefinition)mesh, (int)textureWidth, (int)textureHeight);
    }

    private static void register(EntityRenderersEvent.RegisterLayerDefinitions event, ModelLayerLocation layerLocation, Supplier<LayerDefinition> layer) {
        event.registerLayerDefinition(layerLocation, layer);
    }

    public static void register(EntityRenderersEvent.RegisterLayerDefinitions event) {
        CurioLayers.register(event, SKILLCLOAK, CurioLayers.layer(CloakModel.createCloak(), 64, 64));
        CurioLayers.register(event, HOOD, CurioLayers.layer(HoodModel.createHood(), 64, 64));
    }
}

