/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pavocado.exoticbirds.entity.FlamingoEntity;

@OnlyIn(value=Dist.CLIENT)
public class FlamingoModel<T extends FlamingoEntity>
extends AgeableListModel<T> {
    public static final ModelLayerLocation FLAMINGO_LAYER = new ModelLayerLocation(new ResourceLocation("exoticbirds", "flamingo"), "main");
    private final ModelPart breast;
    private final ModelPart body;
    private final ModelPart midBody;
    private final ModelPart lowerBeak;
    private final ModelPart lowerNeck;
    private final ModelPart upperNeck;
    private final ModelPart middleNeck;
    private final ModelPart head;
    private final ModelPart upperBeak;
    private final ModelPart tail;
    private final ModelPart rightKnee;
    private final ModelPart rightUpperLeg;
    private final ModelPart rightLowerLeg;
    private final ModelPart leftKnee;
    private final ModelPart leftUpperLeg;
    private final ModelPart rightFoot;
    private final ModelPart leftLowerLeg;
    private final ModelPart leftFoot;
    private final ModelPart leftWing;
    private final ModelPart rightWing;

    public FlamingoModel(ModelPart part) {
        this.breast = part.m_171324_("breast");
        this.body = part.m_171324_("body");
        this.midBody = part.m_171324_("midBody");
        this.lowerBeak = part.m_171324_("lowerBeak");
        this.lowerNeck = part.m_171324_("lowerNeck");
        this.upperNeck = part.m_171324_("upperNeck");
        this.middleNeck = part.m_171324_("middleNeck");
        this.head = part.m_171324_("head");
        this.upperBeak = part.m_171324_("upperBeak");
        this.tail = part.m_171324_("tail");
        this.rightKnee = part.m_171324_("rightKnee");
        this.rightUpperLeg = part.m_171324_("rightUpperLeg");
        this.rightLowerLeg = part.m_171324_("rightLowerLeg");
        this.leftKnee = part.m_171324_("leftKnee");
        this.leftUpperLeg = part.m_171324_("leftUpperLeg");
        this.rightFoot = part.m_171324_("rightFoot");
        this.leftLowerLeg = part.m_171324_("leftLowerLeg");
        this.leftFoot = part.m_171324_("leftFoot");
        this.leftWing = part.m_171324_("leftWing");
        this.rightWing = part.m_171324_("rightWing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("breast", CubeListBuilder.m_171558_().m_171514_(19, 0).m_171481_(-2.0f, 0.0f, 0.0f, 4.0f, 4.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)6.9f, (float)-2.3f, (float)0.2268928f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.0f, 0.0f, 0.0f, 6.0f, 6.0f, 7.0f), PartPose.m_171423_((float)0.0f, (float)4.9f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("midBody", CubeListBuilder.m_171558_().m_171514_(33, 0).m_171481_(-2.5f, 0.0f, 0.0f, 5.0f, 5.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)5.9f, (float)5.5f, (float)-0.1745329f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("lowerBeak", CubeListBuilder.m_171558_().m_171514_(26, 16).m_171481_(-1.0f, -11.8f, 0.4f, 2.0f, 2.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)7.4f, (float)-1.0f, (float)0.7413002f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("lowerNeck", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171481_(-1.0f, -3.0f, -2.0f, 2.0f, 4.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)7.4f, (float)-1.0f, (float)0.8953849f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("upperNeck", CubeListBuilder.m_171558_().m_171514_(56, 21).m_171481_(-1.0f, -8.5f, -5.0f, 2.0f, 5.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)7.4f, (float)-1.0f, (float)-0.4363323f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("middleNeck", CubeListBuilder.m_171558_().m_171514_(8, 20).m_171481_(-1.0f, -5.0f, -3.6f, 2.0f, 5.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)7.4f, (float)-1.0f, (float)-0.0872665f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(26, 8).m_171481_(-1.5f, -11.5f, -3.7f, 3.0f, 3.0f, 5.0f), PartPose.m_171423_((float)0.0f, (float)7.4f, (float)-1.0f, (float)0.0349066f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("upperBeak", CubeListBuilder.m_171558_().m_171514_(16, 13).m_171481_(-1.0f, -10.6f, -5.9f, 2.0f, 2.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)7.4f, (float)-1.0f, (float)0.0349066f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171481_(-2.0f, 0.0f, 0.0f, 4.0f, 3.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)6.9f, (float)7.5f, (float)-0.4363323f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightKnee", CubeListBuilder.m_171558_().m_171514_(53, 17).m_171481_(-1.0f, 5.0f, -0.7f, 2.0f, 2.0f, 2.0f), PartPose.m_171423_((float)-1.3f, (float)10.9f, (float)2.0f, (float)0.1745329f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightUpperLeg", CubeListBuilder.m_171558_().m_171514_(53, 0).m_171481_(-0.5f, -1.0f, -0.5f, 1.0f, 7.0f, 1.0f), PartPose.m_171423_((float)-1.3f, (float)10.9f, (float)2.0f, (float)0.2617994f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightLowerLeg", CubeListBuilder.m_171558_().m_171514_(53, 8).m_171481_(-0.5f, 5.0f, 1.8f, 1.0f, 8.0f, 1.0f), PartPose.m_171423_((float)-1.3f, (float)10.9f, (float)2.0f, (float)-0.1745329f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftKnee", CubeListBuilder.m_171558_().m_171514_(45, 17).m_171481_(-1.0f, 5.0f, -0.7f, 2.0f, 2.0f, 2.0f), PartPose.m_171423_((float)1.3f, (float)10.9f, (float)2.0f, (float)0.1745329f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftUpperLeg", CubeListBuilder.m_171558_().m_171514_(49, 0).m_171481_(-0.5f, -1.0f, -0.5f, 1.0f, 7.0f, 1.0f), PartPose.m_171423_((float)1.3f, (float)10.9f, (float)2.0f, (float)0.2617994f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightFoot", CubeListBuilder.m_171558_().m_171514_(46, 25).m_171481_(-2.0f, 13.0f, -3.8f, 3.0f, 0.0f, 4.0f), PartPose.m_171423_((float)-1.3f, (float)10.9f, (float)2.0f, (float)0.0349066f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftLowerLeg", CubeListBuilder.m_171558_().m_171514_(49, 8).m_171481_(-0.5f, 5.0f, 1.8f, 1.0f, 8.0f, 1.0f), PartPose.m_171423_((float)1.3f, (float)10.9f, (float)2.0f, (float)-0.1745329f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftFoot", CubeListBuilder.m_171558_().m_171514_(46, 21).m_171481_(-1.0f, 13.0f, -3.8f, 3.0f, 0.0f, 4.0f), PartPose.m_171423_((float)1.3f, (float)10.9f, (float)2.0f, (float)0.0349066f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftWing", CubeListBuilder.m_171558_().m_171514_(34, 20).m_171481_(0.0f, -1.0f, -1.0f, 1.0f, 5.0f, 7.0f), PartPose.m_171423_((float)3.0f, (float)6.0f, (float)1.0f, (float)-0.3490659f, (float)-0.0872665f, (float)0.0f));
        partdefinition.m_171599_("rightWing", CubeListBuilder.m_171558_().m_171514_(18, 20).m_171481_(-1.0f, -1.0f, -1.0f, 1.0f, 5.0f, 7.0f), PartPose.m_171423_((float)-3.0f, (float)6.0f, (float)1.0f, (float)-0.3490659f, (float)0.0872665f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.lowerNeck, (Object)this.upperNeck, (Object)this.middleNeck, (Object)this.head, (Object)this.upperBeak);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.breast, (Object)this.body, (Object)this.midBody, (Object)this.tail, (Object)this.rightKnee, (Object)this.rightUpperLeg, (Object)this.rightLowerLeg, (Object)this.leftKnee, (Object)this.leftUpperLeg, (Object)this.rightFoot, (Object)this.leftLowerLeg, (Object)this.leftFoot, (Object[])new ModelPart[]{this.leftWing, this.rightWing});
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.rightUpperLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount + 0.2617994f;
        this.rightFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount + 0.0349066f;
        this.rightLowerLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount - 0.1745329f;
        this.rightKnee.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount + 0.1745329f;
        this.rightWing.f_104205_ = ageInTicks;
        this.leftWing.f_104205_ = -ageInTicks;
        this.head.f_104204_ = netHeadYaw / 57.295776f;
        this.upperNeck.f_104204_ = netHeadYaw / 57.295776f;
        this.middleNeck.f_104204_ = netHeadYaw / 57.295776f;
        this.lowerNeck.f_104204_ = netHeadYaw / 57.295776f;
        this.lowerBeak.f_104204_ = netHeadYaw / 57.295776f;
        this.upperBeak.f_104204_ = netHeadYaw / 57.295776f;
        if (!((FlamingoEntity)((Object)entityIn)).getIsStanding()) {
            this.leftUpperLeg.m_104227_(1.3f, 10.9f, 2.0f);
            this.leftKnee.m_104227_(1.3f, 10.9f, 2.0f);
            this.leftLowerLeg.m_104227_(1.3f, 10.9f, 2.0f);
            this.leftFoot.m_104227_(1.3f, 10.9f, 2.0f);
            this.leftUpperLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount + 0.2617994f;
            this.leftFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount + 0.0349066f;
            this.leftLowerLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount - 0.1745329f;
            this.leftKnee.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount + 0.1745329f;
        } else {
            this.leftUpperLeg.m_104227_(1.3f, 10.9f, 2.0f);
            this.leftKnee.m_104227_(1.3f, 10.9f, 2.0f);
            this.leftLowerLeg.m_104227_(1.3f, 9.6f, 13.0f);
            this.leftFoot.m_104227_(1.3f, 24.9f, -6.0f);
            this.leftUpperLeg.f_104203_ = 1.3962634f;
            this.leftKnee.f_104203_ = 1.3089969f;
            this.leftFoot.f_104203_ = 2.617993f;
            this.leftLowerLeg.f_104203_ = -1.43117f;
        }
    }

    public void m_7695_(PoseStack stack, VertexConsumer builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            stack.m_85836_();
            stack.m_85841_(0.6f, 0.6f, 0.6f);
            stack.m_85837_(0.0, 1.0, 0.0);
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            stack.m_85836_();
            stack.m_85841_(1.05f, 1.05f, 1.05f);
            stack.m_85837_(0.0, 0.0, (double)0.01f);
            this.lowerBeak.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha);
            stack.m_85849_();
            stack.m_85849_();
        } else {
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            stack.m_85836_();
            stack.m_85841_(1.05f, 1.05f, 1.05f);
            stack.m_85837_(0.0, 0.0, (double)0.01f);
            this.lowerBeak.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha);
            stack.m_85849_();
        }
    }
}

