/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.item.crafting;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.pavocado.exoticbirds.init.ExoticBirdsRecipes;
import net.pavocado.exoticbirds.item.BirdEggItem;

public class EggDustingRecipe
extends CustomRecipe {
    public EggDustingRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingContainer inv, Level level) {
        ItemStack itemstack = ItemStack.f_41583_;
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack itemstack1 = inv.m_8020_(i);
            if (itemstack1.m_41619_()) continue;
            if (itemstack1.m_41720_() instanceof BirdEggItem && BirdEggItem.canIncubate(itemstack1, 100)) {
                if (!itemstack.m_41619_()) {
                    return false;
                }
                itemstack = itemstack1;
                continue;
            }
            if (itemstack1.m_41720_() != Items.f_42593_) {
                return false;
            }
            list.add(itemstack1);
        }
        return !itemstack.m_41619_() && !list.isEmpty();
    }

    public ItemStack assemble(CraftingContainer inv) {
        ItemStack itemstack = ItemStack.f_41583_;
        int powderCount = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack itemstack1 = inv.m_8020_(i);
            if (itemstack1.m_41619_()) continue;
            Item item = itemstack1.m_41720_();
            if (itemstack1.m_41720_() instanceof BirdEggItem && BirdEggItem.canIncubate(itemstack1, 100)) {
                if (!itemstack.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                itemstack = itemstack1.m_41777_();
                itemstack.m_41764_(1);
                continue;
            }
            if (item != Items.f_42593_) {
                return ItemStack.f_41583_;
            }
            ++powderCount;
        }
        if (!itemstack.m_41619_()) {
            CompoundTag tag = itemstack.m_41698_("EggValues");
            if (tag.m_128441_("SpawnChance")) {
                int spawnChance = tag.m_128451_("SpawnChance");
                if (spawnChance < 100) {
                    tag.m_128405_("SpawnChance", Math.min(spawnChance + 10 * powderCount, 100));
                }
            } else {
                tag.m_128405_("SpawnChance", Math.min(30 + 10 * powderCount, 100));
            }
        }
        return itemstack;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ExoticBirdsRecipes.EGG_DUSTING.get();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }
}

